/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         xreparse
#define yylex           xrelex
#define yyerror         xreerror
#define yydebug         xredebug
#define yynerrs         xrenerrs

/* First part of user prologue.  */
#line 1 "xre_parse.yy"

// Copyright (c) 2016 University of Helsinki
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3 of the License, or (at your option) any later version.
// See the file COPYING included with this distribution for more
// information.

#define YYDEBUG 1

#include <stdio.h>
#include <assert.h>
#include <iostream>

#include "HfstTransducer.h"
#include "HfstInputStream.h"
#include "HfstXeroxRules.h"

using namespace hfst;
using hfst::HfstTransducer;
using namespace hfst::xeroxRules;
using namespace hfst::implementations;

#include "xre_utils.h"

namespace hfst {
  namespace xre {
    // number of characters read, used for scanning function definition xre for argument symbols
    extern unsigned int cr;
    extern bool harmonize_;
    extern bool harmonize_flags_;
    extern bool allow_extra_text_at_end;

    bool has_weight_been_zeroed = false; // to control how many times a warning is given
    float zero_weights(float f)
    {
        if ((! has_weight_been_zeroed) && (f != 0))
        {
            hfst::xre::warn("warning: ignoring weights in rule context\n");
            has_weight_been_zeroed = true;
        }
        return 0;
    }

    bool is_weighted()
    {
        return (hfst::xre::format == hfst::TROPICAL_OPENFST_TYPE ||
                hfst::xre::format == hfst::LOG_OPENFST_TYPE);
    }
  }
}

using hfst::xre::harmonize_;
using hfst::xre::harmonize_flags_;

union YYSTYPE;
struct yy_buffer_state;
typedef yy_buffer_state * YY_BUFFER_STATE;
typedef void * yyscan_t;

extern int xreparse(yyscan_t);
extern int xrelex_init (yyscan_t*);
extern YY_BUFFER_STATE xre_scan_string (const char *, yyscan_t);
extern void xre_delete_buffer (YY_BUFFER_STATE, yyscan_t);
extern int xrelex_destroy (yyscan_t);

extern int xreerror(yyscan_t, const char*);
extern int xreerror(const char*);
int xrelex ( YYSTYPE * , yyscan_t );


#line 150 "xre_parse.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_XRE_XRE_PARSE_HH_INCLUDED
# define YY_XRE_XRE_PARSE_HH_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif
#if YYDEBUG
extern int xredebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    WEIGHT = 258,                  /* WEIGHT  */
    SYMBOL = 259,                  /* SYMBOL  */
    MULTICHAR_SYMBOL = 260,        /* MULTICHAR_SYMBOL  */
    CURLY_BRACKETS = 261,          /* CURLY_BRACKETS  */
    CROSS_PRODUCT = 262,           /* CROSS_PRODUCT  */
    COMPOSITION = 263,             /* COMPOSITION  */
    LENIENT_COMPOSITION = 264,     /* LENIENT_COMPOSITION  */
    INTERSECTION = 265,            /* INTERSECTION  */
    MERGE_RIGHT_ARROW = 266,       /* MERGE_RIGHT_ARROW  */
    MERGE_LEFT_ARROW = 267,        /* MERGE_LEFT_ARROW  */
    CENTER_MARKER = 268,           /* CENTER_MARKER  */
    MARKUP_MARKER = 269,           /* MARKUP_MARKER  */
    SHUFFLE = 270,                 /* SHUFFLE  */
    LEFT_RESTRICTION = 271,        /* LEFT_RESTRICTION  */
    LEFT_ARROW = 272,              /* LEFT_ARROW  */
    RIGHT_ARROW = 273,             /* RIGHT_ARROW  */
    LEFT_RIGHT_ARROW = 274,        /* LEFT_RIGHT_ARROW  */
    REPLACE_RIGHT = 275,           /* REPLACE_RIGHT  */
    REPLACE_LEFT = 276,            /* REPLACE_LEFT  */
    OPTIONAL_REPLACE_RIGHT = 277,  /* OPTIONAL_REPLACE_RIGHT  */
    OPTIONAL_REPLACE_LEFT = 278,   /* OPTIONAL_REPLACE_LEFT  */
    REPLACE_LEFT_RIGHT = 279,      /* REPLACE_LEFT_RIGHT  */
    OPTIONAL_REPLACE_LEFT_RIGHT = 280, /* OPTIONAL_REPLACE_LEFT_RIGHT  */
    RTL_LONGEST_MATCH = 281,       /* RTL_LONGEST_MATCH  */
    RTL_SHORTEST_MATCH = 282,      /* RTL_SHORTEST_MATCH  */
    LTR_LONGEST_MATCH = 283,       /* LTR_LONGEST_MATCH  */
    LTR_SHORTEST_MATCH = 284,      /* LTR_SHORTEST_MATCH  */
    REPLACE_CONTEXT_UU = 285,      /* REPLACE_CONTEXT_UU  */
    REPLACE_CONTEXT_LU = 286,      /* REPLACE_CONTEXT_LU  */
    REPLACE_CONTEXT_UL = 287,      /* REPLACE_CONTEXT_UL  */
    REPLACE_CONTEXT_LL = 288,      /* REPLACE_CONTEXT_LL  */
    UNION = 289,                   /* UNION  */
    MINUS = 290,                   /* MINUS  */
    UPPER_MINUS = 291,             /* UPPER_MINUS  */
    LOWER_MINUS = 292,             /* LOWER_MINUS  */
    UPPER_PRIORITY_UNION = 293,    /* UPPER_PRIORITY_UNION  */
    LOWER_PRIORITY_UNION = 294,    /* LOWER_PRIORITY_UNION  */
    IGNORING = 295,                /* IGNORING  */
    IGNORE_INTERNALLY = 296,       /* IGNORE_INTERNALLY  */
    LEFT_QUOTIENT = 297,           /* LEFT_QUOTIENT  */
    COMMACOMMA = 298,              /* COMMACOMMA  */
    COMMA = 299,                   /* COMMA  */
    BEFORE = 300,                  /* BEFORE  */
    AFTER = 301,                   /* AFTER  */
    SUBSTITUTE_LEFT = 302,         /* SUBSTITUTE_LEFT  */
    TERM_COMPLEMENT = 303,         /* TERM_COMPLEMENT  */
    COMPLEMENT = 304,              /* COMPLEMENT  */
    CONTAINMENT = 305,             /* CONTAINMENT  */
    CONTAINMENT_ONCE = 306,        /* CONTAINMENT_ONCE  */
    CONTAINMENT_OPT = 307,         /* CONTAINMENT_OPT  */
    REVERSE = 308,                 /* REVERSE  */
    INVERT = 309,                  /* INVERT  */
    XRE_UPPER = 310,               /* XRE_UPPER  */
    XRE_LOWER = 311,               /* XRE_LOWER  */
    STAR = 312,                    /* STAR  */
    PLUS = 313,                    /* PLUS  */
    CATENATE_N_TO_K = 314,         /* CATENATE_N_TO_K  */
    CATENATE_N = 315,              /* CATENATE_N  */
    CATENATE_N_PLUS = 316,         /* CATENATE_N_PLUS  */
    CATENATE_N_MINUS = 317,        /* CATENATE_N_MINUS  */
    READ_BIN = 318,                /* READ_BIN  */
    READ_TEXT = 319,               /* READ_TEXT  */
    READ_SPACED = 320,             /* READ_SPACED  */
    READ_PROLOG = 321,             /* READ_PROLOG  */
    READ_RE = 322,                 /* READ_RE  */
    FUNCTION_NAME = 323,           /* FUNCTION_NAME  */
    LEFT_BRACKET = 324,            /* LEFT_BRACKET  */
    RIGHT_BRACKET = 325,           /* RIGHT_BRACKET  */
    LEFT_PARENTHESIS = 326,        /* LEFT_PARENTHESIS  */
    RIGHT_PARENTHESIS = 327,       /* RIGHT_PARENTHESIS  */
    LEFT_BRACKET_DOTTED = 328,     /* LEFT_BRACKET_DOTTED  */
    RIGHT_BRACKET_DOTTED = 329,    /* RIGHT_BRACKET_DOTTED  */
    SUBVAL = 330,                  /* SUBVAL  */
    EPSILON_TOKEN = 331,           /* EPSILON_TOKEN  */
    ANY_TOKEN = 332,               /* ANY_TOKEN  */
    BOUNDARY_MARKER = 333,         /* BOUNDARY_MARKER  */
    LEXER_ERROR = 334,             /* LEXER_ERROR  */
    END_OF_EXPRESSION = 335,       /* END_OF_EXPRESSION  */
    PAIR_SEPARATOR = 336,          /* PAIR_SEPARATOR  */
    QUOTED_LITERAL = 337,          /* QUOTED_LITERAL  */
    QUOTED_MULTICHAR_LITERAL = 338 /* QUOTED_MULTICHAR_LITERAL  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define WEIGHT 258
#define SYMBOL 259
#define MULTICHAR_SYMBOL 260
#define CURLY_BRACKETS 261
#define CROSS_PRODUCT 262
#define COMPOSITION 263
#define LENIENT_COMPOSITION 264
#define INTERSECTION 265
#define MERGE_RIGHT_ARROW 266
#define MERGE_LEFT_ARROW 267
#define CENTER_MARKER 268
#define MARKUP_MARKER 269
#define SHUFFLE 270
#define LEFT_RESTRICTION 271
#define LEFT_ARROW 272
#define RIGHT_ARROW 273
#define LEFT_RIGHT_ARROW 274
#define REPLACE_RIGHT 275
#define REPLACE_LEFT 276
#define OPTIONAL_REPLACE_RIGHT 277
#define OPTIONAL_REPLACE_LEFT 278
#define REPLACE_LEFT_RIGHT 279
#define OPTIONAL_REPLACE_LEFT_RIGHT 280
#define RTL_LONGEST_MATCH 281
#define RTL_SHORTEST_MATCH 282
#define LTR_LONGEST_MATCH 283
#define LTR_SHORTEST_MATCH 284
#define REPLACE_CONTEXT_UU 285
#define REPLACE_CONTEXT_LU 286
#define REPLACE_CONTEXT_UL 287
#define REPLACE_CONTEXT_LL 288
#define UNION 289
#define MINUS 290
#define UPPER_MINUS 291
#define LOWER_MINUS 292
#define UPPER_PRIORITY_UNION 293
#define LOWER_PRIORITY_UNION 294
#define IGNORING 295
#define IGNORE_INTERNALLY 296
#define LEFT_QUOTIENT 297
#define COMMACOMMA 298
#define COMMA 299
#define BEFORE 300
#define AFTER 301
#define SUBSTITUTE_LEFT 302
#define TERM_COMPLEMENT 303
#define COMPLEMENT 304
#define CONTAINMENT 305
#define CONTAINMENT_ONCE 306
#define CONTAINMENT_OPT 307
#define REVERSE 308
#define INVERT 309
#define XRE_UPPER 310
#define XRE_LOWER 311
#define STAR 312
#define PLUS 313
#define CATENATE_N_TO_K 314
#define CATENATE_N 315
#define CATENATE_N_PLUS 316
#define CATENATE_N_MINUS 317
#define READ_BIN 318
#define READ_TEXT 319
#define READ_SPACED 320
#define READ_PROLOG 321
#define READ_RE 322
#define FUNCTION_NAME 323
#define LEFT_BRACKET 324
#define RIGHT_BRACKET 325
#define LEFT_PARENTHESIS 326
#define RIGHT_PARENTHESIS 327
#define LEFT_BRACKET_DOTTED 328
#define RIGHT_BRACKET_DOTTED 329
#define SUBVAL 330
#define EPSILON_TOKEN 331
#define ANY_TOKEN 332
#define BOUNDARY_MARKER 333
#define LEXER_ERROR 334
#define END_OF_EXPRESSION 335
#define PAIR_SEPARATOR 336
#define QUOTED_LITERAL 337
#define QUOTED_MULTICHAR_LITERAL 338

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 82 "xre_parse.yy"


    int value;
    int* values;
    double weight;
    char* label;
    
    char *subval1, *subval2;
    
    hfst::HfstTransducer* transducer;
    hfst::HfstTransducerPair* transducerPair;
    hfst::HfstTransducerPairVector* transducerPairVector;
    hfst::HfstTransducerVector* transducerVector;

   std::pair<hfst::xeroxRules::ReplaceArrow, std::vector<hfst::xeroxRules::Rule> >* replaceRuleVectorWithArrow;
   std::pair< hfst::xeroxRules::ReplaceArrow, hfst::xeroxRules::Rule>* replaceRuleWithArrow;
   std::pair< hfst::xeroxRules::ReplaceArrow, hfst::HfstTransducerPairVector>* mappingVectorWithArrow;
   std::pair< hfst::xeroxRules::ReplaceArrow, hfst::HfstTransducerPair>* mappingWithArrow;
       
   std::pair<hfst::xeroxRules::ReplaceType, hfst::HfstTransducerPairVector>* contextWithMark;
   
   hfst::xeroxRules::ReplaceType replType;
   hfst::xeroxRules::ReplaceArrow replaceArrow;


#line 395 "xre_parse.cc"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif




int xreparse (void * scanner);


#endif /* !YY_XRE_XRE_PARSE_HH_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_WEIGHT = 3,                     /* WEIGHT  */
  YYSYMBOL_SYMBOL = 4,                     /* SYMBOL  */
  YYSYMBOL_MULTICHAR_SYMBOL = 5,           /* MULTICHAR_SYMBOL  */
  YYSYMBOL_CURLY_BRACKETS = 6,             /* CURLY_BRACKETS  */
  YYSYMBOL_CROSS_PRODUCT = 7,              /* CROSS_PRODUCT  */
  YYSYMBOL_COMPOSITION = 8,                /* COMPOSITION  */
  YYSYMBOL_LENIENT_COMPOSITION = 9,        /* LENIENT_COMPOSITION  */
  YYSYMBOL_INTERSECTION = 10,              /* INTERSECTION  */
  YYSYMBOL_MERGE_RIGHT_ARROW = 11,         /* MERGE_RIGHT_ARROW  */
  YYSYMBOL_MERGE_LEFT_ARROW = 12,          /* MERGE_LEFT_ARROW  */
  YYSYMBOL_CENTER_MARKER = 13,             /* CENTER_MARKER  */
  YYSYMBOL_MARKUP_MARKER = 14,             /* MARKUP_MARKER  */
  YYSYMBOL_SHUFFLE = 15,                   /* SHUFFLE  */
  YYSYMBOL_LEFT_RESTRICTION = 16,          /* LEFT_RESTRICTION  */
  YYSYMBOL_LEFT_ARROW = 17,                /* LEFT_ARROW  */
  YYSYMBOL_RIGHT_ARROW = 18,               /* RIGHT_ARROW  */
  YYSYMBOL_LEFT_RIGHT_ARROW = 19,          /* LEFT_RIGHT_ARROW  */
  YYSYMBOL_REPLACE_RIGHT = 20,             /* REPLACE_RIGHT  */
  YYSYMBOL_REPLACE_LEFT = 21,              /* REPLACE_LEFT  */
  YYSYMBOL_OPTIONAL_REPLACE_RIGHT = 22,    /* OPTIONAL_REPLACE_RIGHT  */
  YYSYMBOL_OPTIONAL_REPLACE_LEFT = 23,     /* OPTIONAL_REPLACE_LEFT  */
  YYSYMBOL_REPLACE_LEFT_RIGHT = 24,        /* REPLACE_LEFT_RIGHT  */
  YYSYMBOL_OPTIONAL_REPLACE_LEFT_RIGHT = 25, /* OPTIONAL_REPLACE_LEFT_RIGHT  */
  YYSYMBOL_RTL_LONGEST_MATCH = 26,         /* RTL_LONGEST_MATCH  */
  YYSYMBOL_RTL_SHORTEST_MATCH = 27,        /* RTL_SHORTEST_MATCH  */
  YYSYMBOL_LTR_LONGEST_MATCH = 28,         /* LTR_LONGEST_MATCH  */
  YYSYMBOL_LTR_SHORTEST_MATCH = 29,        /* LTR_SHORTEST_MATCH  */
  YYSYMBOL_REPLACE_CONTEXT_UU = 30,        /* REPLACE_CONTEXT_UU  */
  YYSYMBOL_REPLACE_CONTEXT_LU = 31,        /* REPLACE_CONTEXT_LU  */
  YYSYMBOL_REPLACE_CONTEXT_UL = 32,        /* REPLACE_CONTEXT_UL  */
  YYSYMBOL_REPLACE_CONTEXT_LL = 33,        /* REPLACE_CONTEXT_LL  */
  YYSYMBOL_UNION = 34,                     /* UNION  */
  YYSYMBOL_MINUS = 35,                     /* MINUS  */
  YYSYMBOL_UPPER_MINUS = 36,               /* UPPER_MINUS  */
  YYSYMBOL_LOWER_MINUS = 37,               /* LOWER_MINUS  */
  YYSYMBOL_UPPER_PRIORITY_UNION = 38,      /* UPPER_PRIORITY_UNION  */
  YYSYMBOL_LOWER_PRIORITY_UNION = 39,      /* LOWER_PRIORITY_UNION  */
  YYSYMBOL_IGNORING = 40,                  /* IGNORING  */
  YYSYMBOL_IGNORE_INTERNALLY = 41,         /* IGNORE_INTERNALLY  */
  YYSYMBOL_LEFT_QUOTIENT = 42,             /* LEFT_QUOTIENT  */
  YYSYMBOL_COMMACOMMA = 43,                /* COMMACOMMA  */
  YYSYMBOL_COMMA = 44,                     /* COMMA  */
  YYSYMBOL_BEFORE = 45,                    /* BEFORE  */
  YYSYMBOL_AFTER = 46,                     /* AFTER  */
  YYSYMBOL_SUBSTITUTE_LEFT = 47,           /* SUBSTITUTE_LEFT  */
  YYSYMBOL_TERM_COMPLEMENT = 48,           /* TERM_COMPLEMENT  */
  YYSYMBOL_COMPLEMENT = 49,                /* COMPLEMENT  */
  YYSYMBOL_CONTAINMENT = 50,               /* CONTAINMENT  */
  YYSYMBOL_CONTAINMENT_ONCE = 51,          /* CONTAINMENT_ONCE  */
  YYSYMBOL_CONTAINMENT_OPT = 52,           /* CONTAINMENT_OPT  */
  YYSYMBOL_REVERSE = 53,                   /* REVERSE  */
  YYSYMBOL_INVERT = 54,                    /* INVERT  */
  YYSYMBOL_XRE_UPPER = 55,                 /* XRE_UPPER  */
  YYSYMBOL_XRE_LOWER = 56,                 /* XRE_LOWER  */
  YYSYMBOL_STAR = 57,                      /* STAR  */
  YYSYMBOL_PLUS = 58,                      /* PLUS  */
  YYSYMBOL_CATENATE_N_TO_K = 59,           /* CATENATE_N_TO_K  */
  YYSYMBOL_CATENATE_N = 60,                /* CATENATE_N  */
  YYSYMBOL_CATENATE_N_PLUS = 61,           /* CATENATE_N_PLUS  */
  YYSYMBOL_CATENATE_N_MINUS = 62,          /* CATENATE_N_MINUS  */
  YYSYMBOL_READ_BIN = 63,                  /* READ_BIN  */
  YYSYMBOL_READ_TEXT = 64,                 /* READ_TEXT  */
  YYSYMBOL_READ_SPACED = 65,               /* READ_SPACED  */
  YYSYMBOL_READ_PROLOG = 66,               /* READ_PROLOG  */
  YYSYMBOL_READ_RE = 67,                   /* READ_RE  */
  YYSYMBOL_FUNCTION_NAME = 68,             /* FUNCTION_NAME  */
  YYSYMBOL_LEFT_BRACKET = 69,              /* LEFT_BRACKET  */
  YYSYMBOL_RIGHT_BRACKET = 70,             /* RIGHT_BRACKET  */
  YYSYMBOL_LEFT_PARENTHESIS = 71,          /* LEFT_PARENTHESIS  */
  YYSYMBOL_RIGHT_PARENTHESIS = 72,         /* RIGHT_PARENTHESIS  */
  YYSYMBOL_LEFT_BRACKET_DOTTED = 73,       /* LEFT_BRACKET_DOTTED  */
  YYSYMBOL_RIGHT_BRACKET_DOTTED = 74,      /* RIGHT_BRACKET_DOTTED  */
  YYSYMBOL_SUBVAL = 75,                    /* SUBVAL  */
  YYSYMBOL_EPSILON_TOKEN = 76,             /* EPSILON_TOKEN  */
  YYSYMBOL_ANY_TOKEN = 77,                 /* ANY_TOKEN  */
  YYSYMBOL_BOUNDARY_MARKER = 78,           /* BOUNDARY_MARKER  */
  YYSYMBOL_LEXER_ERROR = 79,               /* LEXER_ERROR  */
  YYSYMBOL_END_OF_EXPRESSION = 80,         /* END_OF_EXPRESSION  */
  YYSYMBOL_PAIR_SEPARATOR = 81,            /* PAIR_SEPARATOR  */
  YYSYMBOL_QUOTED_LITERAL = 82,            /* QUOTED_LITERAL  */
  YYSYMBOL_QUOTED_MULTICHAR_LITERAL = 83,  /* QUOTED_MULTICHAR_LITERAL  */
  YYSYMBOL_YYACCEPT = 84,                  /* $accept  */
  YYSYMBOL_XRE = 85,                       /* XRE  */
  YYSYMBOL_REGEXP1 = 86,                   /* REGEXP1  */
  YYSYMBOL_REGEXP2 = 87,                   /* REGEXP2  */
  YYSYMBOL_SUB1 = 88,                      /* SUB1  */
  YYSYMBOL_SUB2 = 89,                      /* SUB2  */
  YYSYMBOL_SUB3 = 90,                      /* SUB3  */
  YYSYMBOL_REPLACE = 91,                   /* REPLACE  */
  YYSYMBOL_PARALLEL_RULES = 92,            /* PARALLEL_RULES  */
  YYSYMBOL_RULE = 93,                      /* RULE  */
  YYSYMBOL_MAPPINGPAIR_VECTOR = 94,        /* MAPPINGPAIR_VECTOR  */
  YYSYMBOL_MAPPINGPAIR = 95,               /* MAPPINGPAIR  */
  YYSYMBOL_CONTEXTS_WITH_MARK = 96,        /* CONTEXTS_WITH_MARK  */
  YYSYMBOL_CONTEXTS_VECTOR = 97,           /* CONTEXTS_VECTOR  */
  YYSYMBOL_CONTEXT = 98,                   /* CONTEXT  */
  YYSYMBOL_CONTEXT_MARK = 99,              /* CONTEXT_MARK  */
  YYSYMBOL_REPLACE_ARROW = 100,            /* REPLACE_ARROW  */
  YYSYMBOL_REGEXP3 = 101,                  /* REGEXP3  */
  YYSYMBOL_REGEXP4 = 102,                  /* REGEXP4  */
  YYSYMBOL_RESTR_CONTEXTS_VECTOR = 103,    /* RESTR_CONTEXTS_VECTOR  */
  YYSYMBOL_RESTR_CONTEXT = 104,            /* RESTR_CONTEXT  */
  YYSYMBOL_REGEXP5 = 105,                  /* REGEXP5  */
  YYSYMBOL_REGEXP6 = 106,                  /* REGEXP6  */
  YYSYMBOL_REGEXP7 = 107,                  /* REGEXP7  */
  YYSYMBOL_REGEXP8 = 108,                  /* REGEXP8  */
  YYSYMBOL_REGEXP9 = 109,                  /* REGEXP9  */
  YYSYMBOL_REGEXP10 = 110,                 /* REGEXP10  */
  YYSYMBOL_REGEXP11 = 111,                 /* REGEXP11  */
  YYSYMBOL_SYMBOL_LIST = 112,              /* SYMBOL_LIST  */
  YYSYMBOL_REGEXP12 = 113,                 /* REGEXP12  */
  YYSYMBOL_LABEL = 114,                    /* LABEL  */
  YYSYMBOL_SYMBOL_OR_QUOTED = 115,         /* SYMBOL_OR_QUOTED  */
  YYSYMBOL_HALFARC = 116,                  /* HALFARC  */
  YYSYMBOL_REGEXP_LIST = 117,              /* REGEXP_LIST  */
  YYSYMBOL_FUNCTION = 118                  /* FUNCTION  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  59
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   646

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  84
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  35
/* YYNRULES -- Number of rules.  */
#define YYNRULES  135
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  214

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   338


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   174,   174,   176,   182,   189,   196,   200,   225,   229,
     233,   247,   252,   257,   335,   336,   337,   339,   346,   347,
     386,   401,   413,   422,   434,   450,   463,   472,   481,   491,
     501,   511,   518,   526,   536,   542,   550,   558,   591,   613,
     636,   642,   646,   650,   654,   660,   664,   668,   672,   676,
     680,   684,   688,   695,   696,   702,   706,   713,   715,   721,
     729,   738,   746,   755,   760,   770,   776,   784,   785,   789,
     794,   798,   804,   810,   814,   824,   825,   831,   832,   838,
     844,   852,   853,   867,   880,   890,   896,   902,   903,   906,
     909,   912,   915,   918,   921,   924,   928,   931,   937,   938,
     953,   954,   958,   963,   970,   977,   984,   990,   993,   999,
    1010,  1028,  1029,  1032,  1048,  1073,  1098,  1123,  1169,  1183,
    1188,  1196,  1204,  1208,  1214,  1264,  1265,  1269,  1273,  1276,
    1285,  1288,  1291,  1296,  1300,  1307
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "WEIGHT", "SYMBOL",
  "MULTICHAR_SYMBOL", "CURLY_BRACKETS", "CROSS_PRODUCT", "COMPOSITION",
  "LENIENT_COMPOSITION", "INTERSECTION", "MERGE_RIGHT_ARROW",
  "MERGE_LEFT_ARROW", "CENTER_MARKER", "MARKUP_MARKER", "SHUFFLE",
  "LEFT_RESTRICTION", "LEFT_ARROW", "RIGHT_ARROW", "LEFT_RIGHT_ARROW",
  "REPLACE_RIGHT", "REPLACE_LEFT", "OPTIONAL_REPLACE_RIGHT",
  "OPTIONAL_REPLACE_LEFT", "REPLACE_LEFT_RIGHT",
  "OPTIONAL_REPLACE_LEFT_RIGHT", "RTL_LONGEST_MATCH", "RTL_SHORTEST_MATCH",
  "LTR_LONGEST_MATCH", "LTR_SHORTEST_MATCH", "REPLACE_CONTEXT_UU",
  "REPLACE_CONTEXT_LU", "REPLACE_CONTEXT_UL", "REPLACE_CONTEXT_LL",
  "UNION", "MINUS", "UPPER_MINUS", "LOWER_MINUS", "UPPER_PRIORITY_UNION",
  "LOWER_PRIORITY_UNION", "IGNORING", "IGNORE_INTERNALLY", "LEFT_QUOTIENT",
  "COMMACOMMA", "COMMA", "BEFORE", "AFTER", "SUBSTITUTE_LEFT",
  "TERM_COMPLEMENT", "COMPLEMENT", "CONTAINMENT", "CONTAINMENT_ONCE",
  "CONTAINMENT_OPT", "REVERSE", "INVERT", "XRE_UPPER", "XRE_LOWER", "STAR",
  "PLUS", "CATENATE_N_TO_K", "CATENATE_N", "CATENATE_N_PLUS",
  "CATENATE_N_MINUS", "READ_BIN", "READ_TEXT", "READ_SPACED",
  "READ_PROLOG", "READ_RE", "FUNCTION_NAME", "LEFT_BRACKET",
  "RIGHT_BRACKET", "LEFT_PARENTHESIS", "RIGHT_PARENTHESIS",
  "LEFT_BRACKET_DOTTED", "RIGHT_BRACKET_DOTTED", "SUBVAL", "EPSILON_TOKEN",
  "ANY_TOKEN", "BOUNDARY_MARKER", "LEXER_ERROR", "END_OF_EXPRESSION",
  "PAIR_SEPARATOR", "QUOTED_LITERAL", "QUOTED_MULTICHAR_LITERAL",
  "$accept", "XRE", "REGEXP1", "REGEXP2", "SUB1", "SUB2", "SUB3",
  "REPLACE", "PARALLEL_RULES", "RULE", "MAPPINGPAIR_VECTOR", "MAPPINGPAIR",
  "CONTEXTS_WITH_MARK", "CONTEXTS_VECTOR", "CONTEXT", "CONTEXT_MARK",
  "REPLACE_ARROW", "REGEXP3", "REGEXP4", "RESTR_CONTEXTS_VECTOR",
  "RESTR_CONTEXT", "REGEXP5", "REGEXP6", "REGEXP7", "REGEXP8", "REGEXP9",
  "REGEXP10", "REGEXP11", "SYMBOL_LIST", "REGEXP12", "LABEL",
  "SYMBOL_OR_QUOTED", "HALFARC", "REGEXP_LIST", "FUNCTION", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-124)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     177,  -124,  -124,   -70,   -53,    13,   457,   137,   457,   457,
    -124,  -124,  -124,  -124,  -124,  -124,   177,   177,   217,  -124,
    -124,  -124,  -124,  -124,    26,  -124,    21,    83,   610,   -22,
    -124,   124,  -124,    28,   130,   277,   457,   150,  -124,   566,
    -124,  -124,  -124,    24,  -124,   -47,   177,   467,   377,  -124,
    -124,   457,  -124,  -124,  -124,    33,    46,   610,   490,  -124,
     377,   377,   377,   377,   377,  -124,   274,   -35,  -124,  -124,
    -124,  -124,  -124,  -124,  -124,  -124,   257,   377,  -124,  -124,
    -124,  -124,   377,  -124,   297,   457,   457,   457,   457,   417,
     457,   457,   457,   457,   457,   457,   457,   457,   150,   457,
     457,   457,  -124,  -124,  -124,  -124,  -124,  -124,  -124,  -124,
    -124,  -124,  -124,   485,   265,   -34,  -124,   177,  -124,   100,
    -124,    12,  -124,   377,   610,   610,   610,   610,   610,   610,
    -124,  -124,   314,  -124,  -124,    83,   377,   337,   589,   610,
    -124,  -124,   377,   579,    -9,  -124,   130,   130,   130,   399,
     457,    81,    -7,  -124,   559,   457,   457,   457,   457,   457,
     457,   457,  -124,  -124,  -124,  -124,   177,  -124,   177,  -124,
     167,  -124,  -124,   497,   610,   377,  -124,  -124,     3,   610,
     610,   561,   377,   610,   377,   297,   457,   130,   457,   417,
     457,   186,   265,  -124,  -124,   177,  -124,   610,    83,   610,
     610,   610,  -124,   277,   130,  -124,   277,  -124,   227,   -25,
    -124,    83,   -11,  -124
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       3,   125,   126,   122,     0,     0,     0,     0,     0,     0,
     113,   114,   115,   116,   117,   135,     0,     0,     0,   130,
     131,   132,   128,   127,     0,     2,     5,     0,     6,    19,
      21,    22,    25,    18,    53,    57,    67,    75,    77,    81,
      87,    98,   100,   111,   129,   118,     0,     0,     0,    99,
      82,     0,    83,    85,    86,     0,     0,     0,     0,     1,
       0,     0,     0,     0,     0,     4,     0,     0,    45,    51,
      46,    52,    47,    48,    49,    50,     0,     0,    41,    42,
      43,    44,     0,    23,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    76,     0,
       0,     0,    90,    91,    92,    93,    88,    89,    97,    94,
      95,    96,   112,     0,   134,     0,   123,     0,   121,     0,
      84,   101,   108,     0,     0,     8,     7,     9,    10,    11,
      17,    13,     0,   109,    15,     0,     0,     0,    26,     0,
      20,    24,    40,     0,    34,    35,    54,    55,    56,     0,
      66,     0,    58,    61,     0,    69,    68,    70,    71,    72,
      73,    74,    78,    79,    80,   120,     0,   119,     0,   124,
       0,    14,   107,     0,    30,     0,    16,   110,     0,    29,
      32,     0,    28,    39,    38,     0,     0,    65,    64,     0,
       0,     0,   133,   104,   103,     0,   105,    31,     0,    33,
      27,    37,    36,    59,    63,    62,    60,   106,     0,     0,
     102,     0,     0,    12
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -124,  -124,  -124,   -15,  -124,  -124,  -124,   -12,  -124,   -17,
    -124,   -20,  -124,  -124,  -122,  -124,   -49,  -124,   -82,  -124,
    -123,   -76,   549,   -23,    16,  -124,    64,  -124,  -124,  -124,
    -124,  -124,   -27,  -124,  -124
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,    24,    25,    26,    27,    66,   131,    28,    29,    30,
      31,    32,    83,   144,   145,    84,    76,    33,    34,   152,
     153,    35,    36,    37,    38,    39,    40,    41,   132,    42,
      43,    44,    45,   115,    46
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
      67,    55,    56,   146,   147,   148,    58,   151,   123,   134,
     168,    47,   149,    98,   154,   172,    48,     1,     2,     3,
     118,    77,    50,    52,    53,    54,    59,   112,    60,    61,
      62,   114,    63,    64,   113,   185,   119,   189,   169,   133,
      60,    61,    62,    85,    63,    64,   135,   198,   125,   126,
     127,   128,   129,    60,    61,    62,   211,    63,    64,   213,
     140,     5,   141,   202,   138,   139,   205,   120,   187,    49,
     139,     0,   143,    86,    87,   175,    10,    11,    12,    13,
      14,    15,    16,     0,    17,     0,   167,     1,     2,    19,
      20,    21,     0,   173,   188,    22,    23,     0,    88,    89,
      90,    65,   170,   121,     0,   177,   204,   151,   178,     0,
     203,   174,     0,     0,   206,   162,   163,   164,   122,     0,
      68,    69,    70,    71,   179,   181,    72,    73,    74,    75,
     183,   123,    98,    98,    98,    98,    98,    98,    98,     0,
      51,     1,     2,     3,   171,     0,   196,    88,    89,    90,
     175,   191,     0,   192,    78,    79,    80,    81,     0,    19,
      20,    21,     0,   197,     0,    22,    23,     0,    82,     0,
     200,   209,   201,   143,    60,    61,    62,     0,    63,    64,
     208,     1,     2,     3,   212,     5,     6,     7,     8,     9,
      99,   100,   101,    60,    61,    62,     0,    63,    64,     0,
      10,    11,    12,    13,    14,    15,    16,     0,    17,     0,
       0,     0,     0,    19,    20,    21,     0,     0,     0,    22,
      23,     1,     2,     3,     4,     5,     6,     7,     8,     9,
       0,     0,     0,     0,    60,    61,    62,   193,    63,    64,
      10,    11,    12,    13,    14,    15,    16,     0,    17,     0,
      18,     0,     0,    19,    20,    21,   207,     0,     0,    22,
      23,     1,     2,     3,     0,     5,     6,     7,     8,     9,
       0,   136,    60,    61,    62,     0,    63,    64,     1,     2,
      10,    11,    12,    13,    14,    15,    16,    91,    17,     0,
      18,    57,     0,    19,    20,    21,     0,   210,     0,    22,
      23,     1,     2,     3,     0,     5,     6,     7,     8,     9,
     142,    92,    93,    94,    95,    96,    97,     0,     1,     2,
      10,    11,    12,    13,    14,    15,    16,     0,    17,     0,
     137,     0,     0,    19,    20,    21,     0,     0,     0,    22,
      23,     1,     2,     3,   130,     5,     6,     7,     8,     9,
      19,    20,    21,     0,     0,     0,    22,    23,     0,     0,
      10,    11,    12,    13,    14,    15,    16,     0,    17,     0,
      18,     0,     0,    19,    20,    21,     0,     0,     0,    22,
      23,     1,     2,     3,   176,     5,     6,     7,     8,     9,
      19,    20,    21,     0,     0,     0,    22,    23,     0,     0,
      10,    11,    12,    13,    14,    15,    16,     0,    17,    91,
      18,   180,   186,    19,    20,    21,     0,     0,     0,    22,
      23,     1,     2,     3,     0,     5,     6,     7,     8,     9,
     150,     0,     0,    92,    93,    94,    95,    96,    97,     0,
      10,    11,    12,    13,    14,    15,    16,     0,    17,     0,
      18,     0,     0,    19,    20,    21,     0,     0,     0,    22,
      23,     1,     2,     3,     0,     5,     6,     7,     8,     9,
       0,     1,     2,   116,     0,     0,     0,     0,     0,     0,
      10,    11,    12,    13,    14,    15,    16,     0,    17,     1,
       2,   165,     0,    19,    20,    21,     0,     0,     0,    22,
      23,     1,     2,   194,     0,     5,     6,     7,     8,     9,
      68,    69,    70,    71,     0,     0,    72,    73,    74,    75,
      10,    11,    12,    13,    14,    15,    16,     0,    17,     0,
       0,     0,     0,    19,    20,    21,   117,     0,     0,    22,
      23,     0,     0,    19,    20,    21,     0,     0,     0,    22,
      23,     0,     0,     0,   166,     0,     0,     0,     0,     0,
       0,    19,    20,    21,   124,     0,   195,    22,    23,    91,
       0,     0,   190,    19,    20,    21,     0,     0,     0,    22,
      23,    68,    69,    70,    71,     0,     0,    72,    73,    74,
      75,     0,   184,    92,    93,    94,    95,    96,    97,    68,
      69,    70,    71,   182,     0,    72,    73,    74,    75,    68,
      69,    70,    71,     0,     0,    72,    73,    74,    75,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,     0,
      68,    69,    70,    71,     0,   199,    72,    73,    74,    75,
     155,   156,   157,   158,   159,   160,   161
};

static const yytype_int16 yycheck[] =
{
      27,    16,    17,    85,    86,    87,    18,    89,    57,    44,
      44,    81,    88,    36,    90,     3,    69,     4,     5,     6,
      47,    43,     6,     7,     8,     9,     0,     3,     7,     8,
       9,    46,    11,    12,    81,    44,    48,    44,    72,    66,
       7,     8,     9,    15,    11,    12,    81,    44,    60,    61,
      62,    63,    64,     7,     8,     9,    81,    11,    12,    70,
      77,    48,    82,   185,    76,    77,   189,    51,   150,     5,
      82,    -1,    84,    45,    46,   124,    63,    64,    65,    66,
      67,    68,    69,    -1,    71,    -1,   113,     4,     5,    76,
      77,    78,    -1,    81,    13,    82,    83,    -1,    17,    18,
      19,    80,   117,    70,    -1,   132,   188,   189,   135,    -1,
     186,   123,    -1,    -1,   190,    99,   100,   101,    72,    -1,
      20,    21,    22,    23,   136,   137,    26,    27,    28,    29,
     142,   180,   155,   156,   157,   158,   159,   160,   161,    -1,
       3,     4,     5,     6,    44,    -1,   173,    17,    18,    19,
     199,   166,    -1,   168,    30,    31,    32,    33,    -1,    76,
      77,    78,    -1,   175,    -1,    82,    83,    -1,    44,    -1,
     182,   198,   184,   185,     7,     8,     9,    -1,    11,    12,
     195,     4,     5,     6,   211,    48,    49,    50,    51,    52,
      40,    41,    42,     7,     8,     9,    -1,    11,    12,    -1,
      63,    64,    65,    66,    67,    68,    69,    -1,    71,    -1,
      -1,    -1,    -1,    76,    77,    78,    -1,    -1,    -1,    82,
      83,     4,     5,     6,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    -1,     7,     8,     9,    70,    11,    12,
      63,    64,    65,    66,    67,    68,    69,    -1,    71,    -1,
      73,    -1,    -1,    76,    77,    78,    70,    -1,    -1,    82,
      83,     4,     5,     6,    -1,    48,    49,    50,    51,    52,
      -1,    14,     7,     8,     9,    -1,    11,    12,     4,     5,
      63,    64,    65,    66,    67,    68,    69,    10,    71,    -1,
      73,    74,    -1,    76,    77,    78,    -1,    70,    -1,    82,
      83,     4,     5,     6,    -1,    48,    49,    50,    51,    52,
      13,    34,    35,    36,    37,    38,    39,    -1,     4,     5,
      63,    64,    65,    66,    67,    68,    69,    -1,    71,    -1,
      73,    -1,    -1,    76,    77,    78,    -1,    -1,    -1,    82,
      83,     4,     5,     6,    70,    48,    49,    50,    51,    52,
      76,    77,    78,    -1,    -1,    -1,    82,    83,    -1,    -1,
      63,    64,    65,    66,    67,    68,    69,    -1,    71,    -1,
      73,    -1,    -1,    76,    77,    78,    -1,    -1,    -1,    82,
      83,     4,     5,     6,    70,    48,    49,    50,    51,    52,
      76,    77,    78,    -1,    -1,    -1,    82,    83,    -1,    -1,
      63,    64,    65,    66,    67,    68,    69,    -1,    71,    10,
      73,    74,    13,    76,    77,    78,    -1,    -1,    -1,    82,
      83,     4,     5,     6,    -1,    48,    49,    50,    51,    52,
      13,    -1,    -1,    34,    35,    36,    37,    38,    39,    -1,
      63,    64,    65,    66,    67,    68,    69,    -1,    71,    -1,
      73,    -1,    -1,    76,    77,    78,    -1,    -1,    -1,    82,
      83,     4,     5,     6,    -1,    48,    49,    50,    51,    52,
      -1,     4,     5,     6,    -1,    -1,    -1,    -1,    -1,    -1,
      63,    64,    65,    66,    67,    68,    69,    -1,    71,     4,
       5,     6,    -1,    76,    77,    78,    -1,    -1,    -1,    82,
      83,     4,     5,     6,    -1,    48,    49,    50,    51,    52,
      20,    21,    22,    23,    -1,    -1,    26,    27,    28,    29,
      63,    64,    65,    66,    67,    68,    69,    -1,    71,    -1,
      -1,    -1,    -1,    76,    77,    78,    69,    -1,    -1,    82,
      83,    -1,    -1,    76,    77,    78,    -1,    -1,    -1,    82,
      83,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    77,    78,    74,    -1,    69,    82,    83,    10,
      -1,    -1,    13,    76,    77,    78,    -1,    -1,    -1,    82,
      83,    20,    21,    22,    23,    -1,    -1,    26,    27,    28,
      29,    -1,    13,    34,    35,    36,    37,    38,    39,    20,
      21,    22,    23,    14,    -1,    26,    27,    28,    29,    20,
      21,    22,    23,    -1,    -1,    26,    27,    28,    29,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    -1,
      20,    21,    22,    23,    -1,    74,    26,    27,    28,    29,
      91,    92,    93,    94,    95,    96,    97
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     4,     5,     6,    47,    48,    49,    50,    51,    52,
      63,    64,    65,    66,    67,    68,    69,    71,    73,    76,
      77,    78,    82,    83,    85,    86,    87,    88,    91,    92,
      93,    94,    95,   101,   102,   105,   106,   107,   108,   109,
     110,   111,   113,   114,   115,   116,   118,    81,    69,   110,
     108,     3,   108,   108,   108,    87,    87,    74,    91,     0,
       7,     8,     9,    11,    12,    80,    89,   116,    20,    21,
      22,    23,    26,    27,    28,    29,   100,    43,    30,    31,
      32,    33,    44,    96,    99,    15,    45,    46,    17,    18,
      19,    10,    34,    35,    36,    37,    38,    39,   107,    40,
      41,    42,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,     3,    81,    87,   117,     6,    69,   116,    91,
     108,    70,    72,   100,    74,    91,    91,    91,    91,    91,
      70,    90,   112,   116,    44,    81,    14,    73,    91,    91,
      93,    95,    13,    91,    97,    98,   102,   102,   102,   105,
      13,   102,   103,   104,   105,   106,   106,   106,   106,   106,
     106,   106,   108,   108,   108,     6,    69,   116,    44,    72,
      87,    44,     3,    81,    91,   100,    70,   116,   116,    91,
      74,    91,    14,    91,    13,    44,    13,   102,    13,    44,
      13,    87,    87,    70,     6,    69,   116,    91,    44,    74,
      91,    91,    98,   105,   102,   104,   105,    70,    87,   116,
      70,    81,   116,    70
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    84,    85,    85,    86,    86,    87,    87,    87,    87,
      87,    87,    87,    87,    88,    89,    90,    90,    91,    91,
      92,    92,    93,    93,    94,    94,    95,    95,    95,    95,
      95,    95,    95,    95,    96,    97,    97,    98,    98,    98,
      98,    99,    99,    99,    99,   100,   100,   100,   100,   100,
     100,   100,   100,   101,   101,   101,   101,   102,   102,   102,
     102,   103,   103,   104,   104,   104,   104,   105,   105,   105,
     105,   105,   105,   105,   105,   106,   106,   107,   107,   107,
     107,   108,   108,   108,   108,   108,   108,   109,   109,   109,
     109,   109,   109,   109,   109,   109,   109,   109,   110,   110,
     111,   111,   111,   111,   111,   111,   111,   111,   111,   112,
     112,   113,   113,   113,   113,   113,   113,   113,   114,   114,
     114,   114,   114,   114,   114,   115,   115,   115,   115,   116,
     116,   116,   116,   117,   117,   118
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     0,     2,     1,     1,     3,     3,     3,
       3,     3,     9,     3,     4,     2,     2,     1,     1,     1,
       3,     1,     1,     2,     3,     1,     3,     5,     4,     4,
       4,     5,     4,     5,     2,     1,     3,     3,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     1,     3,     5,
       5,     1,     3,     3,     2,     2,     1,     1,     3,     3,
       3,     3,     3,     3,     3,     1,     2,     1,     3,     3,
       3,     1,     2,     2,     3,     2,     2,     1,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     1,     2,
       1,     3,     7,     5,     5,     5,     5,     4,     3,     1,
       2,     1,     2,     1,     1,     1,     1,     1,     1,     3,
       3,     3,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void * scanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (scanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void * scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, void * scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, void * scanner)
{
  YY_USE (yyvaluep);
  YY_USE (scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (void * scanner)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, scanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* XRE: REGEXP1  */
#line 174 "xre_parse.yy"
             { (yyval.transducer) = (yyvsp[0].transducer); }
#line 2026 "xre_parse.cc"
    break;

  case 3: /* XRE: %empty  */
#line 176 "xre_parse.yy"
     {
       // only comments
       hfst::xre::contains_only_comments = true;
       return 0;
     }
#line 2036 "xre_parse.cc"
    break;

  case 4: /* REGEXP1: REGEXP2 END_OF_EXPRESSION  */
#line 182 "xre_parse.yy"
                                   {
       hfst::xre::last_compiled = (yyvsp[-1].transducer);
       (yyval.transducer) = hfst::xre::last_compiled;
       if (hfst::xre::allow_extra_text_at_end) {
         return 0;
       }
   }
#line 2048 "xre_parse.cc"
    break;

  case 5: /* REGEXP1: REGEXP2  */
#line 189 "xre_parse.yy"
             {
        hfst::xre::last_compiled = (yyvsp[0].transducer);
        (yyval.transducer) = hfst::xre::last_compiled;
   }
#line 2057 "xre_parse.cc"
    break;

  case 6: /* REGEXP2: REPLACE  */
#line 197 "xre_parse.yy"
         {
            (yyval.transducer) = & (yyvsp[0].transducer)->optimize();
         }
#line 2065 "xre_parse.cc"
    break;

  case 7: /* REGEXP2: REGEXP2 COMPOSITION REPLACE  */
#line 201 "xre_parse.yy"
       {
        if ((yyvsp[-2].transducer)->has_flag_diacritics() && (yyvsp[0].transducer)->has_flag_diacritics())
          {
            if (! harmonize_flags_) {
                 hfst::xre::warn("warning: both composition arguments contain flag diacritics that are not harmonized\n");
            }
            else {
                (yyvsp[-2].transducer)->harmonize_flag_diacritics(*(yyvsp[0].transducer));
            }
          }

         try {
            (yyval.transducer) = & (yyvsp[-2].transducer)->compose(*(yyvsp[0].transducer), harmonize_).optimize();
         }
         catch (const FlagDiacriticsAreNotIdentitiesException & e)
             {
               (void)e;
               xreerror("Error: flag diacritics must be identities in composition if flag-is-epsilon is ON.\n"
               "I.e. only FLAG:FLAG is allowed, not FLAG1:FLAG2, FLAG:bar or foo:FLAG\n"
               "Apply twosided flag-diacritics (tfd) before composition.\n");
               YYABORT;
             }
            delete (yyvsp[0].transducer);
        }
#line 2094 "xre_parse.cc"
    break;

  case 8: /* REGEXP2: REGEXP2 CROSS_PRODUCT REPLACE  */
#line 225 "xre_parse.yy"
                                       {
            (yyval.transducer) = & (yyvsp[-2].transducer)->cross_product(*(yyvsp[0].transducer)).optimize();
            delete (yyvsp[0].transducer);
        }
#line 2103 "xre_parse.cc"
    break;

  case 9: /* REGEXP2: REGEXP2 LENIENT_COMPOSITION REPLACE  */
#line 229 "xre_parse.yy"
                                             {
            (yyval.transducer) = & (yyvsp[-2].transducer)->lenient_composition(*(yyvsp[0].transducer)).optimize();
            delete (yyvsp[0].transducer);
        }
#line 2112 "xre_parse.cc"
    break;

  case 10: /* REGEXP2: REGEXP2 MERGE_RIGHT_ARROW REPLACE  */
#line 233 "xre_parse.yy"
                                           {
          try {
            (yyval.transducer) = & hfst::xre::merge_first_to_second((yyvsp[-2].transducer), (yyvsp[0].transducer))->optimize();
          }
          catch (const TransducersAreNotAutomataException & e)
          {
            (void)e;
            xreerror("Error: transducers must be automata in merge operation.");
            delete (yyvsp[-2].transducer);
            delete (yyvsp[0].transducer);
            YYABORT;
          }
          delete (yyvsp[-2].transducer);
       }
#line 2131 "xre_parse.cc"
    break;

  case 11: /* REGEXP2: REGEXP2 MERGE_LEFT_ARROW REPLACE  */
#line 247 "xre_parse.yy"
                                          {
            (yyval.transducer) = & hfst::xre::merge_first_to_second((yyvsp[0].transducer), (yyvsp[-2].transducer))->optimize();
            delete (yyvsp[0].transducer);
       }
#line 2140 "xre_parse.cc"
    break;

  case 12: /* REGEXP2: SUB1 HALFARC PAIR_SEPARATOR HALFARC COMMA HALFARC PAIR_SEPARATOR HALFARC RIGHT_BRACKET  */
#line 252 "xre_parse.yy"
                                                                                                {
            (yyvsp[-8].transducer)->substitute(StringPair((yyvsp[-7].label),(yyvsp[-5].label)), StringPair((yyvsp[-3].label),(yyvsp[-1].label)));
            (yyval.transducer) = & (yyvsp[-8].transducer)->optimize();
            free((yyvsp[-7].label)); free((yyvsp[-5].label)); free((yyvsp[-3].label)); free((yyvsp[-1].label));
       }
#line 2150 "xre_parse.cc"
    break;

  case 13: /* REGEXP2: SUB1 SUB2 SUB3  */
#line 257 "xre_parse.yy"
                        {

            StringSet alpha = (yyvsp[-2].transducer)->get_alphabet();
            if (hfst::xre::is_definition((yyvsp[-1].label)))
            {
                hfst::xre::warn("warning: using definition as an ordinary label, cannot substitute\n");
                (yyval.transducer) = & (yyvsp[-2].transducer)->optimize();
            }
            else if (alpha.find((yyvsp[-1].label)) == alpha.end())
            {
                (yyval.transducer) = & (yyvsp[-2].transducer)->optimize();
            }
            else
            {
                alpha = (yyvsp[0].transducer)->get_alphabet();

                StringPair tmp((yyvsp[-1].label), (yyvsp[-1].label));
                HfstTransducer * tmpTr = new HfstTransducer(*(yyvsp[-2].transducer));

	        bool empty_replace_transducer=false;
	        HfstTransducer empty(hfst::xre::format);
	        if (empty.compare(*(yyvsp[0].transducer)))
	        {
                        empty_replace_transducer=true;
	        }

	        if (empty_replace_transducer)
	        {
                        // substitute all transitions {b:a, a:b, b:b} with b:b
		        // as they will be removed anyway
		        hfst::xre::set_substitution_function_symbol((yyvsp[-1].label));
		        tmpTr->substitute(&hfst::xre::substitution_function);
	        }

                // `[ a:b, b, x y ]
                // substitute b with x | y
                tmpTr->substitute(tmp, *(yyvsp[0].transducer), false); // no harmonization

	        if (!empty_replace_transducer)
                {
                        // a:b .o. b -> x | y
                        // [[a:b].i .o. b -> x | y].i - this is for cases when b is on left side

	                // build Replace transducer
                        HfstTransducerPair mappingPair(HfstTransducer((yyvsp[-1].label), (yyvsp[-1].label), hfst::xre::format), *(yyvsp[0].transducer));
                        HfstTransducerPairVector mappingPairVector;
                        mappingPairVector.push_back(mappingPair);
                        Rule rule(mappingPairVector);
                        HfstTransducer replaceTr(hfst::xre::format);
                        replaceTr = replace(rule, false);

                        // if we are replacing with flag diacritics, the rule must allow
                        // flags to be replaced with themselves
                        StringSet alpha = (yyvsp[0].transducer)->get_alphabet();
                        for (StringSet::const_iterator it = alpha.begin(); it != alpha.end(); it++)
                        {
                          if (FdOperation::is_diacritic(*it))
                          {
                            replaceTr.insert_freely(StringPair(*it, *it), false);
                          }
                        }
                        replaceTr.optimize();

                        tmpTr->compose(replaceTr).optimize();
                        tmpTr->invert().compose(replaceTr).invert();
	        }
            
                if (alpha.find((yyvsp[-1].label)) == alpha.end())
                {
                  tmpTr->remove_from_alphabet((yyvsp[-1].label));
                }
                tmpTr->optimize();
                (yyval.transducer) = tmpTr;
                delete (yyvsp[-2].transducer); free((yyvsp[-1].label)); delete (yyvsp[0].transducer);
            }
         }
#line 2231 "xre_parse.cc"
    break;

  case 14: /* SUB1: SUBSTITUTE_LEFT LEFT_BRACKET REPLACE COMMA  */
#line 335 "xre_parse.yy"
                                                 { (yyval.transducer) = (yyvsp[-1].transducer); }
#line 2237 "xre_parse.cc"
    break;

  case 15: /* SUB2: HALFARC COMMA  */
#line 336 "xre_parse.yy"
                    { (yyval.label) = (yyvsp[-1].label); }
#line 2243 "xre_parse.cc"
    break;

  case 16: /* SUB3: SYMBOL_LIST RIGHT_BRACKET  */
#line 337 "xre_parse.yy"
                                {  (yyval.transducer) = (yyvsp[-1].transducer);  }
#line 2249 "xre_parse.cc"
    break;

  case 17: /* SUB3: RIGHT_BRACKET  */
#line 339 "xre_parse.yy"
                    { (yyval.transducer) = new HfstTransducer(hfst::xre::format); }
#line 2255 "xre_parse.cc"
    break;

  case 18: /* REPLACE: REGEXP3  */
#line 346 "xre_parse.yy"
                  { (yyval.transducer) = (yyvsp[0].transducer); }
#line 2261 "xre_parse.cc"
    break;

  case 19: /* REPLACE: PARALLEL_RULES  */
#line 348 "xre_parse.yy"
         {
            switch ( (yyvsp[0].replaceRuleVectorWithArrow)->first )
            {
               case E_REPLACE_RIGHT:
                 (yyval.transducer) = new HfstTransducer( replace( (yyvsp[0].replaceRuleVectorWithArrow)->second, false ) );
                 break;
               case E_OPTIONAL_REPLACE_RIGHT:
                 (yyval.transducer) = new HfstTransducer( replace( (yyvsp[0].replaceRuleVectorWithArrow)->second, true ) );
                 break;
              case E_REPLACE_LEFT:
                 (yyval.transducer) = new HfstTransducer( replace_left( (yyvsp[0].replaceRuleVectorWithArrow)->second, false ) );
                 break;
               case E_OPTIONAL_REPLACE_LEFT:
                 (yyval.transducer) = new HfstTransducer( replace_left( (yyvsp[0].replaceRuleVectorWithArrow)->second, true ) );
                 break;
               case E_RTL_LONGEST_MATCH:
                 (yyval.transducer) = new HfstTransducer( replace_rightmost_longest_match( (yyvsp[0].replaceRuleVectorWithArrow)->second ) );
                 break;
               case E_RTL_SHORTEST_MATCH:
                 (yyval.transducer) = new HfstTransducer( replace_rightmost_shortest_match((yyvsp[0].replaceRuleVectorWithArrow)->second) );
                 break;
               case E_LTR_LONGEST_MATCH:
                 (yyval.transducer) = new HfstTransducer( replace_leftmost_longest_match( (yyvsp[0].replaceRuleVectorWithArrow)->second ) );
                 break;
               case E_LTR_SHORTEST_MATCH:
                 (yyval.transducer) = new HfstTransducer( replace_leftmost_shortest_match( (yyvsp[0].replaceRuleVectorWithArrow)->second ) );
                 break;
               case E_REPLACE_RIGHT_MARKUP:
               default:
                xreerror("Unhandled arrow stuff I suppose");
                YYABORT;
                break;
            }
       
            delete (yyvsp[0].replaceRuleVectorWithArrow);
         }
#line 2302 "xre_parse.cc"
    break;

  case 20: /* PARALLEL_RULES: PARALLEL_RULES COMMACOMMA RULE  */
#line 387 "xre_parse.yy"
         {
           //std::cerr << "parallel_rules: parallel_rules ,, rule"<< std::endl;
           if ((yyvsp[0].replaceRuleWithArrow)->first != (yyvsp[-2].replaceRuleVectorWithArrow)->first)
           {
             delete (yyvsp[0].replaceRuleWithArrow);
             delete (yyvsp[-2].replaceRuleVectorWithArrow);
             xreerror("Replace type mismatch in parallel rules");
             YYABORT;
           }
            Rule tmpRule((yyvsp[0].replaceRuleWithArrow)->second);
            (yyvsp[-2].replaceRuleVectorWithArrow)->second.push_back(tmpRule);
            (yyval.replaceRuleVectorWithArrow) =  new std::pair< ReplaceArrow, std::vector<Rule> > ((yyvsp[0].replaceRuleWithArrow)->first, (yyvsp[-2].replaceRuleVectorWithArrow)->second);
            delete (yyvsp[-2].replaceRuleVectorWithArrow); delete (yyvsp[0].replaceRuleWithArrow);
         }
#line 2321 "xre_parse.cc"
    break;

  case 21: /* PARALLEL_RULES: RULE  */
#line 402 "xre_parse.yy"
         {
         //std::cerr << "parallel_rules:rule"<< std::endl;
            std::vector<Rule> * ruleVector = new std::vector<Rule>();
            ruleVector->push_back((yyvsp[0].replaceRuleWithArrow)->second);
            
            (yyval.replaceRuleVectorWithArrow) =  new std::pair< ReplaceArrow, std::vector<Rule> > ((yyvsp[0].replaceRuleWithArrow)->first, *ruleVector);
            delete ruleVector;
            delete (yyvsp[0].replaceRuleWithArrow);
         }
#line 2335 "xre_parse.cc"
    break;

  case 22: /* RULE: MAPPINGPAIR_VECTOR  */
#line 414 "xre_parse.yy"
      {
         // std::cerr << "rule: mapping_vector"<< std::endl;
        // HfstTransducer allMappingsDisjuncted = disjunctVectorMembers($1->second);
         
         Rule rule( (yyvsp[0].mappingVectorWithArrow)->second );;
         (yyval.replaceRuleWithArrow) =  new std::pair< ReplaceArrow, Rule> ((yyvsp[0].mappingVectorWithArrow)->first, rule);
         delete (yyvsp[0].mappingVectorWithArrow);
      }
#line 2348 "xre_parse.cc"
    break;

  case 23: /* RULE: MAPPINGPAIR_VECTOR CONTEXTS_WITH_MARK  */
#line 423 "xre_parse.yy"
      {
       //  std::cerr << "rule: mapping_vector contextsWM"<< std::endl;
     //   HfstTransducer allMappingsDisjuncted = disjunctVectorMembers($1->second);
        
        Rule rule( (yyvsp[-1].mappingVectorWithArrow)->second, (yyvsp[0].contextWithMark)->second, (yyvsp[0].contextWithMark)->first );
        (yyval.replaceRuleWithArrow) =  new std::pair< ReplaceArrow, Rule> ((yyvsp[-1].mappingVectorWithArrow)->first, rule);
        delete (yyvsp[-1].mappingVectorWithArrow); delete (yyvsp[0].contextWithMark);
      }
#line 2361 "xre_parse.cc"
    break;

  case 24: /* MAPPINGPAIR_VECTOR: MAPPINGPAIR_VECTOR COMMA MAPPINGPAIR  */
#line 435 "xre_parse.yy"
      {
        // std::cerr << "mapping_vector : mapping_vector comma mapping"<< std::endl;
         // check if new Arrow is the same as the first one

         if ((yyvsp[-2].mappingVectorWithArrow)->first != (yyvsp[0].mappingWithArrow)->first)
         {
            hfst::xre::warn("Replace arrows should be the same. Calculated as if all replacements had the first arrow.");
         }
 
         (yyvsp[-2].mappingVectorWithArrow)->second.push_back((yyvsp[0].mappingWithArrow)->second);
         (yyval.mappingVectorWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPairVector> ((yyvsp[-2].mappingVectorWithArrow)->first, (yyvsp[-2].mappingVectorWithArrow)->second);
         delete (yyvsp[-2].mappingVectorWithArrow); delete (yyvsp[0].mappingWithArrow);
            
      }
#line 2380 "xre_parse.cc"
    break;

  case 25: /* MAPPINGPAIR_VECTOR: MAPPINGPAIR  */
#line 451 "xre_parse.yy"
      {
         // std::cerr << "mapping_vector : mapping"<< std::endl;
         HfstTransducerPairVector * mappingPairVector = new HfstTransducerPairVector();
         mappingPairVector->push_back( (yyvsp[0].mappingWithArrow)->second );
         (yyval.mappingVectorWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPairVector> ((yyvsp[0].mappingWithArrow)->first, * mappingPairVector);
         delete mappingPairVector;
         delete (yyvsp[0].mappingWithArrow);
      }
#line 2393 "xre_parse.cc"
    break;

  case 26: /* MAPPINGPAIR: REPLACE REPLACE_ARROW REPLACE  */
#line 464 "xre_parse.yy"
      {
	  hfst::xre::warn_about_special_symbols_in_replace((yyvsp[-2].transducer));
	  hfst::xre::warn_about_special_symbols_in_replace((yyvsp[0].transducer));
          HfstTransducerPair mappingPair(*(yyvsp[-2].transducer), *(yyvsp[0].transducer));
          (yyval.mappingWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPair> ((yyvsp[-1].replaceArrow), mappingPair);

          delete (yyvsp[-2].transducer); delete (yyvsp[0].transducer);
      }
#line 2406 "xre_parse.cc"
    break;

  case 27: /* MAPPINGPAIR: REPLACE REPLACE_ARROW REPLACE MARKUP_MARKER REPLACE  */
#line 473 "xre_parse.yy"
      {
          HfstTransducerPair marks(*(yyvsp[-2].transducer), *(yyvsp[0].transducer));
          HfstTransducerPair tmpMappingPair(*(yyvsp[-4].transducer), HfstTransducer(hfst::xre::format));
          HfstTransducerPair mappingPair = create_mapping_for_mark_up_replace( tmpMappingPair, marks );
          
          (yyval.mappingWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPair> ((yyvsp[-3].replaceArrow), mappingPair);
          delete (yyvsp[-4].transducer); delete (yyvsp[-2].transducer); delete (yyvsp[0].transducer);
      }
#line 2419 "xre_parse.cc"
    break;

  case 28: /* MAPPINGPAIR: REPLACE REPLACE_ARROW REPLACE MARKUP_MARKER  */
#line 482 "xre_parse.yy"
      {
          HfstTransducer epsilon(hfst::internal_epsilon, hfst::xre::format);
          HfstTransducerPair marks(*(yyvsp[-1].transducer), epsilon);
          HfstTransducerPair tmpMappingPair(*(yyvsp[-3].transducer), HfstTransducer(hfst::xre::format));
          HfstTransducerPair mappingPair = create_mapping_for_mark_up_replace( tmpMappingPair, marks );
                   
          (yyval.mappingWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPair> ((yyvsp[-2].replaceArrow), mappingPair);
          delete (yyvsp[-3].transducer); delete (yyvsp[-1].transducer);
      }
#line 2433 "xre_parse.cc"
    break;

  case 29: /* MAPPINGPAIR: REPLACE REPLACE_ARROW MARKUP_MARKER REPLACE  */
#line 492 "xre_parse.yy"
      {
          HfstTransducer epsilon(hfst::internal_epsilon, hfst::xre::format);
          HfstTransducerPair marks(epsilon, *(yyvsp[0].transducer));
          HfstTransducerPair tmpMappingPair(*(yyvsp[-3].transducer), HfstTransducer(hfst::xre::format));
          HfstTransducerPair mappingPair = create_mapping_for_mark_up_replace( tmpMappingPair, marks );
          
          (yyval.mappingWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPair> ((yyvsp[-2].replaceArrow), mappingPair);
          delete (yyvsp[-3].transducer); delete (yyvsp[0].transducer);
      }
#line 2447 "xre_parse.cc"
    break;

  case 30: /* MAPPINGPAIR: LEFT_BRACKET_DOTTED RIGHT_BRACKET_DOTTED REPLACE_ARROW REPLACE  */
#line 502 "xre_parse.yy"
      {
          HfstTransducer epsilon(hfst::internal_epsilon, hfst::xre::format);
          //HfstTransducer mappingTr(epsilon);
          //mappingTr.cross_product(*$4);
          HfstTransducerPair mappingPair(epsilon, *(yyvsp[0].transducer));
          
          (yyval.mappingWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPair> ((yyvsp[-1].replaceArrow), mappingPair);
          delete (yyvsp[0].transducer);
      }
#line 2461 "xre_parse.cc"
    break;

  case 31: /* MAPPINGPAIR: LEFT_BRACKET_DOTTED REPLACE RIGHT_BRACKET_DOTTED REPLACE_ARROW REPLACE  */
#line 512 "xre_parse.yy"
      {
	  HfstTransducerPair mappingPair(*(yyvsp[-3].transducer), *(yyvsp[0].transducer));
          (yyval.mappingWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPair> ((yyvsp[-1].replaceArrow), mappingPair);
          delete (yyvsp[-3].transducer); delete (yyvsp[0].transducer);
      }
#line 2471 "xre_parse.cc"
    break;

  case 32: /* MAPPINGPAIR: REPLACE REPLACE_ARROW LEFT_BRACKET_DOTTED RIGHT_BRACKET_DOTTED  */
#line 519 "xre_parse.yy"
      {
          HfstTransducer epsilon(hfst::internal_epsilon, hfst::xre::format);
          HfstTransducerPair mappingPair(*(yyvsp[-3].transducer), epsilon);
          
          (yyval.mappingWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPair> ((yyvsp[-2].replaceArrow), mappingPair);
          delete (yyvsp[-3].transducer);
      }
#line 2483 "xre_parse.cc"
    break;

  case 33: /* MAPPINGPAIR: REPLACE REPLACE_ARROW LEFT_BRACKET_DOTTED REPLACE RIGHT_BRACKET_DOTTED  */
#line 527 "xre_parse.yy"
      {
          HfstTransducerPair mappingPair(*(yyvsp[-4].transducer), *(yyvsp[-1].transducer));
          (yyval.mappingWithArrow) =  new std::pair< ReplaceArrow, HfstTransducerPair> ((yyvsp[-3].replaceArrow), mappingPair);
          delete (yyvsp[-4].transducer); delete (yyvsp[-1].transducer);
      }
#line 2493 "xre_parse.cc"
    break;

  case 34: /* CONTEXTS_WITH_MARK: CONTEXT_MARK CONTEXTS_VECTOR  */
#line 537 "xre_parse.yy"
         {
         (yyval.contextWithMark) =  new std::pair< ReplaceType, HfstTransducerPairVector> ((yyvsp[-1].replType), *(yyvsp[0].transducerPairVector));
         delete (yyvsp[0].transducerPairVector);
         }
#line 2502 "xre_parse.cc"
    break;

  case 35: /* CONTEXTS_VECTOR: CONTEXT  */
#line 543 "xre_parse.yy"
         {
            HfstTransducerPairVector * ContextVector = new HfstTransducerPairVector();
            ContextVector->push_back(*(yyvsp[0].transducerPair));
            (yyval.transducerPairVector) = ContextVector;
            delete (yyvsp[0].transducerPair);
         }
#line 2513 "xre_parse.cc"
    break;

  case 36: /* CONTEXTS_VECTOR: CONTEXTS_VECTOR COMMA CONTEXT  */
#line 551 "xre_parse.yy"
         {
            (yyvsp[-2].transducerPairVector)->push_back(*(yyvsp[0].transducerPair));
            (yyval.transducerPairVector) = (yyvsp[-2].transducerPairVector);
            delete (yyvsp[0].transducerPair);
         }
#line 2523 "xre_parse.cc"
    break;

  case 37: /* CONTEXT: REPLACE CENTER_MARKER REPLACE  */
#line 559 "xre_parse.yy"
         {
            if (hfst::xre::has_non_identity_pairs((yyvsp[-2].transducer))) // if non-identity symbols present..
            {
              xreerror("Contexts need to be automata");
              YYABORT;
            }
            if (hfst::xre::has_non_identity_pairs((yyvsp[0].transducer))) // if non-identity symbols present..
            {
              xreerror("Contexts need to be automata");
              YYABORT;
            }
            
            HfstTransducer t1(*(yyvsp[-2].transducer));
            HfstTransducer t2(*(yyvsp[0].transducer));

             if (hfst::xre::is_weighted())
             {
               hfst::xre::has_weight_been_zeroed=false;
               t1.transform_weights(&hfst::xre::zero_weights);
             }
             t1.optimize().prune_alphabet(false);

             if (hfst::xre::is_weighted())
             {
               t2.transform_weights(&hfst::xre::zero_weights);
               hfst::xre::has_weight_been_zeroed=false;
             }
             t2.optimize().prune_alphabet(false);

            (yyval.transducerPair) = new HfstTransducerPair(t1, t2);
            delete (yyvsp[-2].transducer); delete (yyvsp[0].transducer);
         }
#line 2560 "xre_parse.cc"
    break;

  case 38: /* CONTEXT: REPLACE CENTER_MARKER  */
#line 592 "xre_parse.yy"
         {
            if (hfst::xre::has_non_identity_pairs((yyvsp[-1].transducer))) // if non-identity symbols present..
            {
              xreerror("Contexts need to be automata");
              YYABORT;
            }

            HfstTransducer t1(*(yyvsp[-1].transducer));
            
            if (hfst::xre::is_weighted())
            {
              hfst::xre::has_weight_been_zeroed=false;
              t1.transform_weights(&hfst::xre::zero_weights);
              hfst::xre::has_weight_been_zeroed=false;
            }
            t1.optimize().prune_alphabet(false);

            HfstTransducer epsilon(hfst::internal_epsilon, hfst::xre::format);
            (yyval.transducerPair) = new HfstTransducerPair(t1, epsilon);
            delete (yyvsp[-1].transducer);
         }
#line 2586 "xre_parse.cc"
    break;

  case 39: /* CONTEXT: CENTER_MARKER REPLACE  */
#line 614 "xre_parse.yy"
         {

            if (hfst::xre::has_non_identity_pairs((yyvsp[0].transducer))) // if non-identity symbols present..
            {
              xreerror("Contexts need to be automata");
              YYABORT;
            }
            
            HfstTransducer t1(*(yyvsp[0].transducer));

            if (hfst::xre::is_weighted())
            {
              hfst::xre::has_weight_been_zeroed=false;
              t1.transform_weights(&hfst::xre::zero_weights);
              hfst::xre::has_weight_been_zeroed=false;
            }
            t1.optimize().prune_alphabet(false);
             
            HfstTransducer epsilon(hfst::internal_epsilon, hfst::xre::format);
            (yyval.transducerPair) = new HfstTransducerPair(epsilon, t1);
            delete (yyvsp[0].transducer);
         }
#line 2613 "xre_parse.cc"
    break;

  case 40: /* CONTEXT: CENTER_MARKER  */
#line 637 "xre_parse.yy"
          {
            HfstTransducer epsilon(hfst::internal_epsilon, hfst::xre::format);
            (yyval.transducerPair) = new HfstTransducerPair(epsilon, epsilon);
          }
#line 2622 "xre_parse.cc"
    break;

  case 41: /* CONTEXT_MARK: REPLACE_CONTEXT_UU  */
#line 643 "xre_parse.yy"
         {
            (yyval.replType) = REPL_UP;
         }
#line 2630 "xre_parse.cc"
    break;

  case 42: /* CONTEXT_MARK: REPLACE_CONTEXT_LU  */
#line 647 "xre_parse.yy"
         {
            (yyval.replType) = REPL_RIGHT;
         }
#line 2638 "xre_parse.cc"
    break;

  case 43: /* CONTEXT_MARK: REPLACE_CONTEXT_UL  */
#line 651 "xre_parse.yy"
         {
            (yyval.replType) = REPL_LEFT;
         }
#line 2646 "xre_parse.cc"
    break;

  case 44: /* CONTEXT_MARK: REPLACE_CONTEXT_LL  */
#line 655 "xre_parse.yy"
         {
            (yyval.replType) = REPL_DOWN;
         }
#line 2654 "xre_parse.cc"
    break;

  case 45: /* REPLACE_ARROW: REPLACE_RIGHT  */
#line 661 "xre_parse.yy"
         {
            (yyval.replaceArrow) = E_REPLACE_RIGHT;
         }
#line 2662 "xre_parse.cc"
    break;

  case 46: /* REPLACE_ARROW: OPTIONAL_REPLACE_RIGHT  */
#line 665 "xre_parse.yy"
         {
            (yyval.replaceArrow) = E_OPTIONAL_REPLACE_RIGHT;
         }
#line 2670 "xre_parse.cc"
    break;

  case 47: /* REPLACE_ARROW: RTL_LONGEST_MATCH  */
#line 669 "xre_parse.yy"
          {
            (yyval.replaceArrow) = E_RTL_LONGEST_MATCH;
         }
#line 2678 "xre_parse.cc"
    break;

  case 48: /* REPLACE_ARROW: RTL_SHORTEST_MATCH  */
#line 673 "xre_parse.yy"
          {
            (yyval.replaceArrow) = E_RTL_SHORTEST_MATCH;
         }
#line 2686 "xre_parse.cc"
    break;

  case 49: /* REPLACE_ARROW: LTR_LONGEST_MATCH  */
#line 677 "xre_parse.yy"
          {
            (yyval.replaceArrow) = E_LTR_LONGEST_MATCH;
         }
#line 2694 "xre_parse.cc"
    break;

  case 50: /* REPLACE_ARROW: LTR_SHORTEST_MATCH  */
#line 681 "xre_parse.yy"
          {
            (yyval.replaceArrow) = E_LTR_SHORTEST_MATCH;
         }
#line 2702 "xre_parse.cc"
    break;

  case 51: /* REPLACE_ARROW: REPLACE_LEFT  */
#line 685 "xre_parse.yy"
         {
        	 (yyval.replaceArrow) =  E_REPLACE_LEFT;
         }
#line 2710 "xre_parse.cc"
    break;

  case 52: /* REPLACE_ARROW: OPTIONAL_REPLACE_LEFT  */
#line 689 "xre_parse.yy"
         {
        	 (yyval.replaceArrow) = E_OPTIONAL_REPLACE_LEFT;
         }
#line 2718 "xre_parse.cc"
    break;

  case 53: /* REGEXP3: REGEXP4  */
#line 695 "xre_parse.yy"
                 { (yyval.transducer) = (yyvsp[0].transducer); }
#line 2724 "xre_parse.cc"
    break;

  case 54: /* REGEXP3: REGEXP3 SHUFFLE REGEXP4  */
#line 696 "xre_parse.yy"
                                 {
            xreerror("No shuffle");
            //$$ = $1;
            delete (yyvsp[0].transducer);
            YYABORT;
        }
#line 2735 "xre_parse.cc"
    break;

  case 55: /* REGEXP3: REGEXP3 BEFORE REGEXP4  */
#line 702 "xre_parse.yy"
                                {
            (yyval.transducer) = new HfstTransducer( before (*(yyvsp[-2].transducer), *(yyvsp[0].transducer)) );
            delete (yyvsp[-2].transducer); delete (yyvsp[0].transducer);
        }
#line 2744 "xre_parse.cc"
    break;

  case 56: /* REGEXP3: REGEXP3 AFTER REGEXP4  */
#line 706 "xre_parse.yy"
                               {
            (yyval.transducer) = new HfstTransducer( after (*(yyvsp[-2].transducer), *(yyvsp[0].transducer)) );
            delete (yyvsp[-2].transducer); delete (yyvsp[0].transducer);
        }
#line 2753 "xre_parse.cc"
    break;

  case 57: /* REGEXP4: REGEXP5  */
#line 713 "xre_parse.yy"
                 { (yyval.transducer) = (yyvsp[0].transducer); }
#line 2759 "xre_parse.cc"
    break;

  case 58: /* REGEXP4: REGEXP4 RIGHT_ARROW RESTR_CONTEXTS_VECTOR  */
#line 715 "xre_parse.yy"
                                                   {
            (yyval.transducer) = new HfstTransducer( restriction(*(yyvsp[-2].transducer), *(yyvsp[0].transducerPairVector)) ) ;
            delete (yyvsp[-2].transducer);
            delete (yyvsp[0].transducerPairVector);
        }
#line 2769 "xre_parse.cc"
    break;

  case 59: /* REGEXP4: REGEXP4 LEFT_ARROW REGEXP5 CENTER_MARKER REGEXP5  */
#line 721 "xre_parse.yy"
                                                          {
            xreerror("No Arrows");
            //$$ = $1;
            delete (yyvsp[-2].transducer);
            delete (yyvsp[0].transducer);
            YYABORT;
        }
#line 2781 "xre_parse.cc"
    break;

  case 60: /* REGEXP4: REGEXP4 LEFT_RIGHT_ARROW REGEXP5 CENTER_MARKER REGEXP5  */
#line 729 "xre_parse.yy"
                                                                {
            xreerror("No Arrows");
            //$$ = $1;
            delete (yyvsp[-2].transducer);
            delete (yyvsp[0].transducer);
            YYABORT;
        }
#line 2793 "xre_parse.cc"
    break;

  case 61: /* RESTR_CONTEXTS_VECTOR: RESTR_CONTEXT  */
#line 739 "xre_parse.yy"
         {
            HfstTransducerPairVector * ContextVector = new HfstTransducerPairVector();
            ContextVector->push_back(*(yyvsp[0].transducerPair));
            (yyval.transducerPairVector) = ContextVector;
            delete (yyvsp[0].transducerPair);
         }
#line 2804 "xre_parse.cc"
    break;

  case 62: /* RESTR_CONTEXTS_VECTOR: RESTR_CONTEXTS_VECTOR COMMA RESTR_CONTEXT  */
#line 747 "xre_parse.yy"
         {
            (yyvsp[-2].transducerPairVector)->push_back(*(yyvsp[0].transducerPair));
            (yyval.transducerPairVector) = (yyvsp[-2].transducerPairVector);
            delete (yyvsp[0].transducerPair);
         }
#line 2814 "xre_parse.cc"
    break;

  case 63: /* RESTR_CONTEXT: REGEXP4 CENTER_MARKER REGEXP4  */
#line 756 "xre_parse.yy"
         {
            (yyval.transducerPair) = new HfstTransducerPair(*(yyvsp[-2].transducer), *(yyvsp[0].transducer));
            delete (yyvsp[-2].transducer); delete (yyvsp[0].transducer);
         }
#line 2823 "xre_parse.cc"
    break;

  case 64: /* RESTR_CONTEXT: REGEXP4 CENTER_MARKER  */
#line 761 "xre_parse.yy"
         {
           // std::cerr << "Mapping: \n" << *$1  << std::endl;
            
            HfstTransducer epsilon(hfst::internal_epsilon, hfst::xre::format);
            
           // std::cerr << "Epsilon: \n" << epsilon  << std::endl;
            (yyval.transducerPair) = new HfstTransducerPair(*(yyvsp[-1].transducer), epsilon);
            delete (yyvsp[-1].transducer);
         }
#line 2837 "xre_parse.cc"
    break;

  case 65: /* RESTR_CONTEXT: CENTER_MARKER REGEXP4  */
#line 771 "xre_parse.yy"
         {
            HfstTransducer epsilon(hfst::internal_epsilon, hfst::xre::format);
            (yyval.transducerPair) = new HfstTransducerPair(epsilon, *(yyvsp[0].transducer));
            delete (yyvsp[0].transducer);
         }
#line 2847 "xre_parse.cc"
    break;

  case 66: /* RESTR_CONTEXT: CENTER_MARKER  */
#line 777 "xre_parse.yy"
         {
            HfstTransducer empty(hfst::xre::format);
            (yyval.transducerPair) = new HfstTransducerPair(empty, empty);
         }
#line 2856 "xre_parse.cc"
    break;

  case 67: /* REGEXP5: REGEXP6  */
#line 784 "xre_parse.yy"
                 { (yyval.transducer) = (yyvsp[0].transducer); }
#line 2862 "xre_parse.cc"
    break;

  case 68: /* REGEXP5: REGEXP5 UNION REGEXP6  */
#line 785 "xre_parse.yy"
                               {
            (yyval.transducer) = & (yyvsp[-2].transducer)->disjunct(*(yyvsp[0].transducer), harmonize_);
            delete (yyvsp[0].transducer);
        }
#line 2871 "xre_parse.cc"
    break;

  case 69: /* REGEXP5: REGEXP5 INTERSECTION REGEXP6  */
#line 789 "xre_parse.yy"
                                      {
        // std::cerr << "Intersection: \n"  << std::endl;
            (yyval.transducer) = & (yyvsp[-2].transducer)->intersect(*(yyvsp[0].transducer), harmonize_).optimize().prune_alphabet(false);
            delete (yyvsp[0].transducer);
        }
#line 2881 "xre_parse.cc"
    break;

  case 70: /* REGEXP5: REGEXP5 MINUS REGEXP6  */
#line 794 "xre_parse.yy"
                               {
            (yyval.transducer) = & (yyvsp[-2].transducer)->subtract(*(yyvsp[0].transducer), harmonize_).prune_alphabet(false);
            delete (yyvsp[0].transducer);
        }
#line 2890 "xre_parse.cc"
    break;

  case 71: /* REGEXP5: REGEXP5 UPPER_MINUS REGEXP6  */
#line 798 "xre_parse.yy"
                                     {
            xreerror("No upper minus");
            //$$ = $1;
            delete (yyvsp[0].transducer);
            YYABORT;
        }
#line 2901 "xre_parse.cc"
    break;

  case 72: /* REGEXP5: REGEXP5 LOWER_MINUS REGEXP6  */
#line 804 "xre_parse.yy"
                                     {
            xreerror("No lower minus");
            //$$ = $1;
            delete (yyvsp[0].transducer);
            YYABORT;
        }
#line 2912 "xre_parse.cc"
    break;

  case 73: /* REGEXP5: REGEXP5 UPPER_PRIORITY_UNION REGEXP6  */
#line 810 "xre_parse.yy"
                                              {
            (yyval.transducer) = & (yyvsp[-2].transducer)->priority_union(*(yyvsp[0].transducer));
            delete (yyvsp[0].transducer);
        }
#line 2921 "xre_parse.cc"
    break;

  case 74: /* REGEXP5: REGEXP5 LOWER_PRIORITY_UNION REGEXP6  */
#line 814 "xre_parse.yy"
                                              {
            HfstTransducer* left = new HfstTransducer(*(yyvsp[-2].transducer));
            HfstTransducer* right =  new HfstTransducer(*(yyvsp[0].transducer));
            right->invert();
            left->invert();
            (yyval.transducer) = & (left->priority_union(*right).invert());
            delete (yyvsp[-2].transducer); delete (yyvsp[0].transducer);
        }
#line 2934 "xre_parse.cc"
    break;

  case 75: /* REGEXP6: REGEXP7  */
#line 824 "xre_parse.yy"
                 { (yyval.transducer) = (yyvsp[0].transducer); }
#line 2940 "xre_parse.cc"
    break;

  case 76: /* REGEXP6: REGEXP6 REGEXP7  */
#line 825 "xre_parse.yy"
                         {
        (yyval.transducer) = & (yyvsp[-1].transducer)->concatenate(*(yyvsp[0].transducer), harmonize_);
        delete (yyvsp[0].transducer);
        }
#line 2949 "xre_parse.cc"
    break;

  case 77: /* REGEXP7: REGEXP8  */
#line 831 "xre_parse.yy"
                 { (yyval.transducer) = (yyvsp[0].transducer); }
#line 2955 "xre_parse.cc"
    break;

  case 78: /* REGEXP7: REGEXP7 IGNORING REGEXP8  */
#line 832 "xre_parse.yy"
                                  {
            // this is how ignoring is done in foma and xfst
            (yyvsp[-2].transducer)->harmonize(*(yyvsp[0].transducer), true /*force harmonization also for foma type*/);
            (yyval.transducer) = & (yyvsp[-2].transducer)->insert_freely(*(yyvsp[0].transducer), false); // no harmonization
            delete (yyvsp[0].transducer);
        }
#line 2966 "xre_parse.cc"
    break;

  case 79: /* REGEXP7: REGEXP7 IGNORE_INTERNALLY REGEXP8  */
#line 838 "xre_parse.yy"
                                           {
            xreerror("No ignoring internally");
            //$$ = $1;
            delete (yyvsp[0].transducer);
            YYABORT;
        }
#line 2977 "xre_parse.cc"
    break;

  case 80: /* REGEXP7: REGEXP7 LEFT_QUOTIENT REGEXP8  */
#line 844 "xre_parse.yy"
                                       {
            xreerror("No left quotient");
            //$$ = $1;
            delete (yyvsp[0].transducer);
            YYABORT;
        }
#line 2988 "xre_parse.cc"
    break;

  case 81: /* REGEXP8: REGEXP9  */
#line 852 "xre_parse.yy"
                 { (yyval.transducer) = (yyvsp[0].transducer); }
#line 2994 "xre_parse.cc"
    break;

  case 82: /* REGEXP8: COMPLEMENT REGEXP8  */
#line 853 "xre_parse.yy"
                            {
       		// forbid pair complement (ie ~a:b)
		if (! (yyvsp[0].transducer)->is_automaton())
		{
		  xreerror("Complement operator ~ is defined only for automata\n"
		           "Use expression [[?:?] - A]] instead where A is the relation to be complemented.");
		  YYABORT;
		}
       		HfstTransducer complement = HfstTransducer::identity_pair( hfst::xre::format );
       		complement.repeat_star().optimize();
       		complement.subtract(*(yyvsp[0].transducer)).prune_alphabet(false);
       		(yyval.transducer) = new HfstTransducer(complement);
   			delete (yyvsp[0].transducer);
        }
#line 3013 "xre_parse.cc"
    break;

  case 83: /* REGEXP8: CONTAINMENT REGEXP8  */
#line 867 "xre_parse.yy"
                             {
            // std::cerr << "Containment: \n" << std::endl;
            if (hfst::xre::has_non_identity_pairs((yyvsp[0].transducer))) // if non-identity symbols present..
            {
              hfst::xre::warn("warning: using transducer that is non an automaton in containment\n");
              (yyval.transducer) = hfst::xre::contains((yyvsp[0].transducer)); // ..resort to simple containment
            }
            else
            {
              (yyval.transducer) = hfst::xre::contains_with_weight((yyvsp[0].transducer), 0);
            }
            delete (yyvsp[0].transducer);
        }
#line 3031 "xre_parse.cc"
    break;

  case 84: /* REGEXP8: CONTAINMENT WEIGHT REGEXP8  */
#line 880 "xre_parse.yy"
                                    {
            // std::cerr << "Containment: \n" << std::endl;
            if (hfst::xre::has_non_identity_pairs((yyvsp[0].transducer))) // if non-identity symbols present..
            {
              xreerror("Containment with weight only works with automata");
              YYABORT;
            }
            (yyval.transducer) = hfst::xre::contains_with_weight((yyvsp[0].transducer), hfst::double_to_float((yyvsp[-1].weight)));
            delete (yyvsp[0].transducer);
        }
#line 3046 "xre_parse.cc"
    break;

  case 85: /* REGEXP8: CONTAINMENT_ONCE REGEXP8  */
#line 890 "xre_parse.yy"
                                  {
            //std::cerr << "Contain 1 \n"<< std::endl;

            (yyval.transducer) = hfst::xre::contains_once((yyvsp[0].transducer));
            delete (yyvsp[0].transducer);
        }
#line 3057 "xre_parse.cc"
    break;

  case 86: /* REGEXP8: CONTAINMENT_OPT REGEXP8  */
#line 896 "xre_parse.yy"
                                 {
            (yyval.transducer) = hfst::xre::contains_once_optional((yyvsp[0].transducer));
            delete (yyvsp[0].transducer);
        }
#line 3066 "xre_parse.cc"
    break;

  case 87: /* REGEXP9: REGEXP10  */
#line 902 "xre_parse.yy"
                  { (yyval.transducer) = (yyvsp[0].transducer); }
#line 3072 "xre_parse.cc"
    break;

  case 88: /* REGEXP9: REGEXP9 STAR  */
#line 903 "xre_parse.yy"
                      {
            (yyval.transducer) = & (yyvsp[-1].transducer)->repeat_star();
        }
#line 3080 "xre_parse.cc"
    break;

  case 89: /* REGEXP9: REGEXP9 PLUS  */
#line 906 "xre_parse.yy"
                      {
            (yyval.transducer) = & (yyvsp[-1].transducer)->repeat_plus();
        }
#line 3088 "xre_parse.cc"
    break;

  case 90: /* REGEXP9: REGEXP9 REVERSE  */
#line 909 "xre_parse.yy"
                         {
            (yyval.transducer) = & (yyvsp[-1].transducer)->reverse();
        }
#line 3096 "xre_parse.cc"
    break;

  case 91: /* REGEXP9: REGEXP9 INVERT  */
#line 912 "xre_parse.yy"
                        {
            (yyval.transducer) = & (yyvsp[-1].transducer)->invert();
        }
#line 3104 "xre_parse.cc"
    break;

  case 92: /* REGEXP9: REGEXP9 XRE_UPPER  */
#line 915 "xre_parse.yy"
                           {
            (yyval.transducer) = & (yyvsp[-1].transducer)->input_project();
        }
#line 3112 "xre_parse.cc"
    break;

  case 93: /* REGEXP9: REGEXP9 XRE_LOWER  */
#line 918 "xre_parse.yy"
                           {
            (yyval.transducer) = & (yyvsp[-1].transducer)->output_project();
        }
#line 3120 "xre_parse.cc"
    break;

  case 94: /* REGEXP9: REGEXP9 CATENATE_N  */
#line 921 "xre_parse.yy"
                            {
            (yyval.transducer) = & (yyvsp[-1].transducer)->repeat_n((yyvsp[0].value));
        }
#line 3128 "xre_parse.cc"
    break;

  case 95: /* REGEXP9: REGEXP9 CATENATE_N_PLUS  */
#line 924 "xre_parse.yy"
                                 {
            //std::cerr << "value is ::::: \n"<< $2 << std::endl;
            (yyval.transducer) = & (yyvsp[-1].transducer)->repeat_n_plus((yyvsp[0].value)+1);
        }
#line 3137 "xre_parse.cc"
    break;

  case 96: /* REGEXP9: REGEXP9 CATENATE_N_MINUS  */
#line 928 "xre_parse.yy"
                                  {
            (yyval.transducer) = & (yyvsp[-1].transducer)->repeat_n_minus((yyvsp[0].value)-1);
        }
#line 3145 "xre_parse.cc"
    break;

  case 97: /* REGEXP9: REGEXP9 CATENATE_N_TO_K  */
#line 931 "xre_parse.yy"
                                 {
            (yyval.transducer) = & (yyvsp[-1].transducer)->repeat_n_to_k((yyvsp[0].values)[0], (yyvsp[0].values)[1]);
            free((yyvsp[0].values));
        }
#line 3154 "xre_parse.cc"
    break;

  case 98: /* REGEXP10: REGEXP11  */
#line 937 "xre_parse.yy"
                   { (yyval.transducer) = (yyvsp[0].transducer); }
#line 3160 "xre_parse.cc"
    break;

  case 99: /* REGEXP10: TERM_COMPLEMENT REGEXP10  */
#line 938 "xre_parse.yy"
                                  {
            HfstTransducer* any = new HfstTransducer(hfst::internal_identity,
                                        hfst::xre::format);
            (yyval.transducer) = & ( any->subtract(*(yyvsp[0].transducer)));
            delete (yyvsp[0].transducer);
        }
#line 3171 "xre_parse.cc"
    break;

  case 100: /* REGEXP11: REGEXP12  */
#line 953 "xre_parse.yy"
                   { (yyval.transducer) = (yyvsp[0].transducer); }
#line 3177 "xre_parse.cc"
    break;

  case 101: /* REGEXP11: LEFT_BRACKET REGEXP2 RIGHT_BRACKET  */
#line 954 "xre_parse.yy"
                                             {
            (yyval.transducer) = & (yyvsp[-1].transducer)->optimize();
        }
#line 3185 "xre_parse.cc"
    break;

  case 102: /* REGEXP11: LEFT_BRACKET REGEXP2 RIGHT_BRACKET PAIR_SEPARATOR LEFT_BRACKET REGEXP2 RIGHT_BRACKET  */
#line 958 "xre_parse.yy"
                                                                                               {
            (yyval.transducer) = & (yyvsp[-5].transducer)->cross_product(*(yyvsp[-1].transducer));
            delete (yyvsp[-1].transducer);
        }
#line 3194 "xre_parse.cc"
    break;

  case 103: /* REGEXP11: LEFT_BRACKET REGEXP2 RIGHT_BRACKET PAIR_SEPARATOR CURLY_BRACKETS  */
#line 963 "xre_parse.yy"
                                                                           {
     	    HfstTransducer * tmp = hfst::xre::xfst_curly_label_to_transducer((yyvsp[0].label),(yyvsp[0].label));
            free((yyvsp[0].label));
            (yyval.transducer) = & (yyvsp[-3].transducer)->cross_product(*tmp);
            delete tmp;
        }
#line 3205 "xre_parse.cc"
    break;

  case 104: /* REGEXP11: CURLY_BRACKETS PAIR_SEPARATOR LEFT_BRACKET REGEXP2 RIGHT_BRACKET  */
#line 970 "xre_parse.yy"
                                                                           {
     	    HfstTransducer * tmp = hfst::xre::xfst_curly_label_to_transducer((yyvsp[-4].label),(yyvsp[-4].label));
            free((yyvsp[-4].label));
            (yyval.transducer) = & (yyvsp[-1].transducer)->cross_product(*tmp);
            delete tmp;
        }
#line 3216 "xre_parse.cc"
    break;

  case 105: /* REGEXP11: LEFT_BRACKET REGEXP2 RIGHT_BRACKET PAIR_SEPARATOR HALFARC  */
#line 977 "xre_parse.yy"
                                                                    {
            HfstTransducer * tmp = hfst::xre::expand_definition((yyvsp[0].label));
            free((yyvsp[0].label));
            (yyval.transducer) = & (yyvsp[-3].transducer)->cross_product(*tmp);
            delete tmp;
        }
#line 3227 "xre_parse.cc"
    break;

  case 106: /* REGEXP11: HALFARC PAIR_SEPARATOR LEFT_BRACKET REGEXP2 RIGHT_BRACKET  */
#line 984 "xre_parse.yy"
                                                                    {
            (yyval.transducer) = hfst::xre::expand_definition((yyvsp[-4].label));
            free((yyvsp[-4].label));
            (yyval.transducer) = & (yyval.transducer)->cross_product(*(yyvsp[-1].transducer));
            delete (yyvsp[-1].transducer);
        }
#line 3238 "xre_parse.cc"
    break;

  case 107: /* REGEXP11: LEFT_BRACKET REGEXP2 RIGHT_BRACKET WEIGHT  */
#line 990 "xre_parse.yy"
                                                    {
            (yyval.transducer) = & (yyvsp[-2].transducer)->set_final_weights(hfst::double_to_float((yyvsp[0].weight)), true).optimize();
        }
#line 3246 "xre_parse.cc"
    break;

  case 108: /* REGEXP11: LEFT_PARENTHESIS REGEXP2 RIGHT_PARENTHESIS  */
#line 993 "xre_parse.yy"
                                                     {
            (yyval.transducer) = & (yyvsp[-1].transducer)->optionalize();
        }
#line 3254 "xre_parse.cc"
    break;

  case 109: /* SYMBOL_LIST: HALFARC  */
#line 999 "xre_parse.yy"
                     {
            if (strcmp((yyvsp[0].label), hfst::internal_unknown.c_str()) == 0)
              {
                (yyval.transducer) = new HfstTransducer(hfst::internal_identity, hfst::xre::format);
              }
            else
              {
                (yyval.transducer) = new HfstTransducer((yyvsp[0].label), (yyvsp[0].label), hfst::xre::format);
              }
            free((yyvsp[0].label));
        }
#line 3270 "xre_parse.cc"
    break;

  case 110: /* SYMBOL_LIST: SYMBOL_LIST HALFARC  */
#line 1010 "xre_parse.yy"
                              {
            HfstTransducer * tmp ;
            if (strcmp((yyvsp[0].label), hfst::internal_unknown.c_str()) == 0)
              {
                 tmp = new HfstTransducer(hfst::internal_identity, hfst::xre::format);
              }
            else
              {
                 tmp = new HfstTransducer((yyvsp[0].label), (yyvsp[0].label), hfst::xre::format);
              }

            (yyvsp[-1].transducer)->disjunct(*tmp, false); // do not harmonize
            (yyval.transducer) = & (yyvsp[-1].transducer)->optimize();
            free((yyvsp[0].label));
            delete tmp;
            }
#line 3291 "xre_parse.cc"
    break;

  case 111: /* REGEXP12: LABEL  */
#line 1028 "xre_parse.yy"
                { (yyval.transducer) = (yyvsp[0].transducer); }
#line 3297 "xre_parse.cc"
    break;

  case 112: /* REGEXP12: LABEL WEIGHT  */
#line 1029 "xre_parse.yy"
                       {
            (yyval.transducer) = & (yyvsp[-1].transducer)->set_final_weights(hfst::double_to_float((yyvsp[0].weight)), true);
        }
#line 3305 "xre_parse.cc"
    break;

  case 113: /* REGEXP12: READ_BIN  */
#line 1032 "xre_parse.yy"
                   {
            try {
              hfst::HfstInputStream instream((yyvsp[0].label));
              (yyval.transducer) = new HfstTransducer(instream);
              instream.close();
              free((yyvsp[0].label));
            }
            catch (const HfstException & e) {
              (void) e; // todo handle the exception
              char msg [256];
              sprintf(msg, "Error reading transducer file '%s'.", (yyvsp[0].label));
              xreerror(msg);
              free((yyvsp[0].label));
              YYABORT;
            }
        }
#line 3326 "xre_parse.cc"
    break;

  case 114: /* REGEXP12: READ_TEXT  */
#line 1048 "xre_parse.yy"
                    {
            FILE * f = NULL;
            f = hfst::hfst_fopen((yyvsp[0].label), "r");
            free((yyvsp[0].label));
            if (f == NULL) {
              xreerror("File cannot be opened.\n");
              YYABORT;
            }
            else {
              HfstBasicTransducer tmp;
              HfstTokenizer tok;
              char line [1000];

              while( fgets(line, 1000, f) != NULL )
              {
                hfst::xre::strip_newline(line);
                StringPairVector spv = tok.tokenize(line);
                tmp.disjunct(spv, 0);
              }
              fclose(f);
              HfstTransducer * retval = new HfstTransducer(tmp, hfst::xre::format);
              retval->optimize();
              (yyval.transducer) = retval;
            }
        }
#line 3356 "xre_parse.cc"
    break;

  case 115: /* REGEXP12: READ_SPACED  */
#line 1073 "xre_parse.yy"
                      {
            FILE * f = NULL;
            f = hfst::hfst_fopen((yyvsp[0].label), "r");
            free((yyvsp[0].label));
            if (f == NULL) {
              xreerror("File cannot be opened.\n");
              YYABORT;
            }
            else {
              HfstTokenizer tok;
              HfstBasicTransducer tmp;
              char line [1000];

              while( fgets(line, 1000, f) != NULL )
              {
                hfst::xre::strip_newline(line);
                StringPairVector spv = HfstTokenizer::tokenize_space_separated(line);
                tmp.disjunct(spv, 0);
              }
              fclose(f);
              HfstTransducer * retval = new HfstTransducer(tmp, hfst::xre::format);
              retval->optimize();
              (yyval.transducer) = retval;
            }
        }
#line 3386 "xre_parse.cc"
    break;

  case 116: /* REGEXP12: READ_PROLOG  */
#line 1098 "xre_parse.yy"
                      {
            FILE * f = NULL;
            f = hfst::hfst_fopen((yyvsp[0].label), "r");
            free((yyvsp[0].label));
            if (f == NULL) {
              xreerror("File cannot be opened.\n");
              YYABORT;
            }
            else {
              try {
                unsigned int linecount = 0;
                HfstBasicTransducer tmp = HfstBasicTransducer::read_in_prolog_format(f, linecount);
                fclose(f);
                HfstTransducer * retval = new HfstTransducer(tmp, hfst::xre::format);
                retval->optimize();
                (yyval.transducer) = retval;
              }
              catch (const HfstException & e) {
                (void) e; // todo handle the exception
                fclose(f);
                xreerror("Error reading prolog file.\n");
                YYABORT;
              }
            }
        }
#line 3416 "xre_parse.cc"
    break;

  case 117: /* REGEXP12: READ_RE  */
#line 1123 "xre_parse.yy"
                  {
            FILE * f = NULL;
            f = hfst::hfst_fopen((yyvsp[0].label), "r");
            if (f == NULL) {
              xreerror("File cannot be opened.\n");
              fclose(f);
              free((yyvsp[0].label));
              YYABORT;
            }
            else {
              fclose(f);
              // read the regex in a string
              std::ifstream ifs((yyvsp[0].label));
              free((yyvsp[0].label));
              std::stringstream buffer;
              buffer << ifs.rdbuf();
              char * regex_string = strdup(buffer.str().c_str());

              // create a new scanner for evaluating the regex
              yyscan_t scanner;
              xrelex_init(&scanner);
              YY_BUFFER_STATE bs = xre_scan_string(regex_string, scanner);

              unsigned int chars_read = hfst::xre::cr;
              hfst::xre::cr = 0;

              int parse_retval = xreparse(scanner);

              xre_delete_buffer(bs,scanner);
              xrelex_destroy(scanner);

              free(regex_string);

              hfst::xre::cr = chars_read;

              (yyval.transducer) = hfst::xre::last_compiled;

              if (parse_retval != 0)
              {
                xreerror("Error parsing regex.\n");
                YYABORT;
              }
            }
        }
#line 3465 "xre_parse.cc"
    break;

  case 118: /* LABEL: HALFARC  */
#line 1169 "xre_parse.yy"
               {
        if (strcmp((yyvsp[0].label), hfst::internal_unknown.c_str()) == 0)
          {
            (yyval.transducer) = new HfstTransducer(hfst::internal_identity, hfst::xre::format);
          }
        else
          {
            // HfstTransducer * tmp = new HfstTransducer($1, hfst::xre::format);
	    // $$ = hfst::xre::expand_definition(tmp, $1);
            (yyval.transducer) = hfst::xre::expand_definition((yyvsp[0].label));
          }
        free((yyvsp[0].label));
     }
#line 3483 "xre_parse.cc"
    break;

  case 119: /* LABEL: HALFARC PAIR_SEPARATOR HALFARC  */
#line 1183 "xre_parse.yy"
                                    {
     	(yyval.transducer) = hfst::xre::xfst_label_to_transducer((yyvsp[-2].label),(yyvsp[0].label));
        free((yyvsp[-2].label));
        free((yyvsp[0].label));
     }
#line 3493 "xre_parse.cc"
    break;

  case 120: /* LABEL: HALFARC PAIR_SEPARATOR CURLY_BRACKETS  */
#line 1188 "xre_parse.yy"
                                             {
        (yyval.transducer) = hfst::xre::xfst_label_to_transducer((yyvsp[-2].label),(yyvsp[-2].label));
        free((yyvsp[-2].label));
        HfstTransducer * tmp = hfst::xre::xfst_curly_label_to_transducer((yyvsp[0].label),(yyvsp[0].label));
        free((yyvsp[0].label));
        (yyval.transducer) = & (yyval.transducer)->cross_product(*tmp);
        delete tmp;
     }
#line 3506 "xre_parse.cc"
    break;

  case 121: /* LABEL: CURLY_BRACKETS PAIR_SEPARATOR HALFARC  */
#line 1196 "xre_parse.yy"
                                             {
        HfstTransducer * tmp = hfst::xre::xfst_label_to_transducer((yyvsp[0].label),(yyvsp[0].label));
        free((yyvsp[0].label));
        (yyval.transducer) = hfst::xre::xfst_curly_label_to_transducer((yyvsp[-2].label),(yyvsp[-2].label));
        free((yyvsp[-2].label));
        (yyval.transducer) = & (yyval.transducer)->cross_product(*tmp);
        delete tmp;
     }
#line 3519 "xre_parse.cc"
    break;

  case 122: /* LABEL: CURLY_BRACKETS  */
#line 1204 "xre_parse.yy"
                      {
     	(yyval.transducer) = hfst::xre::xfst_curly_label_to_transducer((yyvsp[0].label),(yyvsp[0].label));
        free((yyvsp[0].label));
     }
#line 3528 "xre_parse.cc"
    break;

  case 123: /* LABEL: CURLY_BRACKETS PAIR_SEPARATOR CURLY_BRACKETS  */
#line 1208 "xre_parse.yy"
                                                    {
     	(yyval.transducer) = hfst::xre::xfst_curly_label_to_transducer((yyvsp[-2].label),(yyvsp[0].label));
        free((yyvsp[-2].label));
	free((yyvsp[0].label));
     }
#line 3538 "xre_parse.cc"
    break;

  case 124: /* LABEL: FUNCTION REGEXP_LIST RIGHT_PARENTHESIS  */
#line 1214 "xre_parse.yy"
                                                {
            if (! hfst::xre::is_valid_function_call((yyvsp[-2].label), (yyvsp[-1].transducerVector))) {
              delete (yyvsp[-2].label); delete (yyvsp[-1].transducerVector);
              return EXIT_FAILURE;
            }
            else {
              // create a new scanner for evaluating the function
              yyscan_t scanner;
              xrelex_init(&scanner);
              YY_BUFFER_STATE bs = xre_scan_string(hfst::xre::get_function_xre((yyvsp[-2].label)),scanner);

              // define special variables so that function arguments get the values given in regexp list
              if (! hfst::xre::define_function_args((yyvsp[-2].label), (yyvsp[-1].transducerVector)))
              {
                xreerror("Could not define function args.\n");  // TODO: more informative message
                free((yyvsp[-2].label)); delete (yyvsp[-1].transducerVector);
                YYABORT;
              }

              delete (yyvsp[-1].transducerVector);
              // if we are scanning a function definition for argument symbols,
              // do not include the characters read when evaluating functions inside it
              unsigned int chars_read = hfst::xre::cr;

              int parse_retval = xreparse(scanner);

              hfst::xre::cr = chars_read;
              hfst::xre::undefine_function_args((yyvsp[-2].label));
              free((yyvsp[-2].label));

              xre_delete_buffer(bs,scanner);
              xrelex_destroy(scanner);

              (yyval.transducer) = hfst::xre::last_compiled;

              if (parse_retval != 0)
              {
                YYABORT;
              }
            }
        }
#line 3584 "xre_parse.cc"
    break;

  case 126: /* SYMBOL_OR_QUOTED: MULTICHAR_SYMBOL  */
#line 1265 "xre_parse.yy"
                        {
       hfst::xre::check_multichar_symbol((yyvsp[0].label));
       (yyval.label) = (yyvsp[0].label);
     }
#line 3593 "xre_parse.cc"
    break;

  case 127: /* SYMBOL_OR_QUOTED: QUOTED_MULTICHAR_LITERAL  */
#line 1269 "xre_parse.yy"
                                {
       hfst::xre::check_multichar_symbol((yyvsp[0].label));
       (yyval.label) = (yyvsp[0].label);
     }
#line 3602 "xre_parse.cc"
    break;

  case 129: /* HALFARC: SYMBOL_OR_QUOTED  */
#line 1277 "xre_parse.yy"
     {
       // Symbols of form <foo> are not harmonized in xfst, that is why
       // they need to be escaped as @_<foo>_@.
       // $$ = hfst::xre::escape_enclosing_angle_brackets($1);
       hfst::xre::warn_about_hfst_special_symbol((yyvsp[0].label));
       hfst::xre::warn_about_xfst_special_symbol((yyvsp[0].label));
       (yyval.label) = (yyvsp[0].label);
     }
#line 3615 "xre_parse.cc"
    break;

  case 130: /* HALFARC: EPSILON_TOKEN  */
#line 1285 "xre_parse.yy"
                     {
        (yyval.label) = strdup(hfst::internal_epsilon.c_str());
     }
#line 3623 "xre_parse.cc"
    break;

  case 131: /* HALFARC: ANY_TOKEN  */
#line 1288 "xre_parse.yy"
                 {
        (yyval.label) = strdup(hfst::internal_unknown.c_str());
     }
#line 3631 "xre_parse.cc"
    break;

  case 132: /* HALFARC: BOUNDARY_MARKER  */
#line 1291 "xre_parse.yy"
                       {
        (yyval.label) = strdup("@#@");
     }
#line 3639 "xre_parse.cc"
    break;

  case 133: /* REGEXP_LIST: REGEXP_LIST COMMA REGEXP2  */
#line 1296 "xre_parse.yy"
                                       {
       (yyval.transducerVector)->push_back(*((yyvsp[0].transducer)));
       delete (yyvsp[0].transducer);
     }
#line 3648 "xre_parse.cc"
    break;

  case 134: /* REGEXP_LIST: REGEXP2  */
#line 1300 "xre_parse.yy"
               {
       (yyval.transducerVector) = new hfst::HfstTransducerVector();
       (yyval.transducerVector)->push_back(*((yyvsp[0].transducer)));
       delete (yyvsp[0].transducer);
     }
#line 3658 "xre_parse.cc"
    break;

  case 135: /* FUNCTION: FUNCTION_NAME  */
#line 1307 "xre_parse.yy"
                        {
        (yyval.label) = strdup((yyvsp[0].label));
    }
#line 3666 "xre_parse.cc"
    break;


#line 3670 "xre_parse.cc"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (scanner, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, scanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 1311 "xre_parse.yy"


